@extends('layout')

@section('title')
    Голосования (Стр. {{ $page->current }})
@stop

@section('content')

    <h1>Голосования</h1>

    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item active">Голосования</li>
        </ol>
    </nav>
 @if (getUser())
        <div class="dob">
            <a class="btn btn-success" href="/votes/create">Создать голосование</a><br>
        </div>
    @endif
   
    @if ($votes->isNotEmpty())
        @foreach ($votes as $vote)
           <div class="votes-block">
            <div class="votes-link-block">
                <a href="/votes/{{ $vote['id'] }}"><i class="fa fa-chart-bar"></i>{{ $vote->title }}</a>
            </div>
            <div class="votes-bottom">
               <span>@if ($vote->topic->id)
                    Тема: <a href="/topics/{{ $vote->topic->id }}">{{ $vote->topic->title }}</a>
                @endif</span>
                <span>Создано: {{ dateFixed($vote->created_at) }}</span>
                <span>Всего голосов: {{ $vote->count }}</span>
            </div>
            </div>
        @endforeach

        {!! pagination($page) !!}
    @else
        {!! showError('Открытых голосований еще нет!') !!}
    @endif

   <div class="votes-arhive"><a href="/votes/history"><i class="fa fa-briefcase"></i> Архив голосований</a></div>
   
@stop
