@extends('layout')

@section('title')
    {{ $vote->title }}
@stop

@section('content')

    <h1>{{ $vote->title }}</h1>

    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item"><a href="/votes">Голосования</a></li>
            <li class="breadcrumb-item active">{{ $vote->title }}</li>
        </ol>
    </nav>
<div class="votes-block">
   <div class="votes-view-block">
    @if ($vote->topic->id)
       <div class="theme">
        Тема: <a href="/topics/{{ $vote->topic->id }}">{{ $vote->topic->title }}</a>
        </div>
    @endif

    @if ((getUser() && empty($vote->poll)) && empty($show))
        <form action="/votes/{{ $vote->id }}" method="post">
            <input type="hidden" name="token" value="{{ $_SESSION['token'] }}">

            @foreach($vote->answers as $answer)
                <label><input name="poll" type="radio" value="{{ $answer['id'] }}"> {{ $answer['answer'] }}</label>
            @endforeach

            <button class="golos">Голосовать</button>
        </form>

       <div class="text"><span>Проголосовало: <b>{{ $vote->count }}</b></span></div>
        
        <a class="result" href="/votes/{{ $vote->id }}?show=true"><i class="fa fa-history"></i> Результаты</a>

   
    @else
        @foreach ($vote->voted as $key => $data)
            <?php $proc = round(($data * 100) / $vote->sum, 1); ?>
            <?php $maxproc = round(($data * 100) / $vote->max); ?>
      
           
            <div class="text"><b>{{ $key }}</b> (Голосов: {{ $data }})</div>
            {!! progressBar($maxproc, $proc.'%') !!}
           
        @endforeach
       

       <div class="text"><span> Проголосовало: <b>{{ $vote->count }}</b></span></div>
       
       <div class="variant">
        
        @if (! empty($show))
           <span><a href="/votes/{{ $vote->id }}"><i class="fa fa-chart-bar"></i> К вариантам</a></span>
        @endif
        <span> <a href="/votes/voters/{{ $vote->id }}"><i class="fa fa-users"></i> Проголосовавшие</a></span>
       </div>
        </div>
    @endif
    </div>
@stop
