@extends('layout')

@section('title')
    {{ $vote->title }}
@stop

@section('content')

    <h1>{{ $vote->title }}</h1>

    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item"><a href="/votes">Голосования</a></li>
            <li class="breadcrumb-item"><a href="/votes/history">История голосований</a></li>
            <li class="breadcrumb-item active">{{ $vote->title }}</li>
        </ol>
    </nav>
<div class="votes-block">
   <div class="votes-view-block">
    @foreach ($vote->voted as $key => $data)
        <?php $proc = round(($data * 100) / $vote->sum, 1); ?>
        <?php $maxproc = round(($data * 100) / $vote->max); ?>

       <div class="text"><b>{{ $key }}</b> (Голосов: {{ $data }})</div>
        {!! progressBar($maxproc, $proc.'%') !!}
    @endforeach

   <div class="votes-bottom">
       <span>Вариантов: <b>{{ count($vote->voted) }}</b></span>
       <span> Проголосовало: <b>{{ $vote->count }}</b></span>
   </div>
  
    </div>
</div>
@stop
