@extends('layout')

@section('title')
    Голосования {{ $vote->title }}
@stop

@section('content')

    <h1>Голосования {{ $vote->title }}</h1>

    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item"><a href="/votes">Голосования</a></li>
            <li class="breadcrumb-item"><a href="/votes/{{ $vote->id }}">{{ $vote->title }}</a></li>
            <li class="breadcrumb-item active">Голосования</li>
        </ol>
    </nav>
<div class="votes-block">
   <div class="votes-view-block">
    <div class="text"><i class="fa fa-chart-bar"></i> Голосов: {{ $vote->count }}</div>
    </div>

    @if ($voters->isNotEmpty())
        @foreach ($voters as $voter)
           <div class="votes-users-block">
            {!! $voter->user->getGender() !!} {!! profile($voter->user) !!} ({{ dateFixed($voter->created_at) }})
             </div>
        @endforeach
    @else
        {!! showError('В голосовании никто не участвовал!') !!}
    @endif
   
</div>
@stop
