<?php
header("Content-type:text/html; charset=utf-8");
?>
<!DOCTYPE html>
<html lang="ru">
<head>
    <title>@yield('title') - {{ setting('title') }}</title>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <link rel="shortcut icon" href="/favicon.ico" type="image/x-icon">
    <link rel="image_src" href="/assets/img/images/icon.png">
     @yield('styles')

    @stack('styles')
    <link rel="stylesheet" href="/themes/WhiteBlack/css/rotor.css">
    <link rel="alternate" href="/news/rss" title="RSS News" type="application/rss+xml">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <meta name="description" content="@yield('description', setting('description'))">
    <meta name="keywords" content="@yield('keywords', setting('keywords'))">
    <meta name="generator" content="Rotor {{ VERSION }}">
</head>
<body>
<div class="wrapp">
<div class="header">
   <div class="logo">
    <a href="/">{{ setting('title') }}</a>
    <!--<a href="/"><img src="{{ setting('logotip') }}" alt="{{ setting('title') }}"></a>-->
    <span class="dest">{{ setting('logos') }}</span>
    </div>
    
     <div class="menu-nav">
          <a id="toggler"  href="#"><span class="icons"></span> <div class="spans"></div></a>
           <ul id="box">
               <li>@yield('menu')</li>
           </ul>
       </div>
</div>




<div class="content">
    <div class="main-block">
        @yield('advertTop')
        @yield('advertUser')
        @yield('note')
        @yield('flash')
        @yield('layout')
        @yield('advertBottom')
    </div>
    
    <div class="sidebar">
          <h1>Последние темы</h1>
           <ul>
               <li>{{ recentTopics() }}</li>
        </ul>
               <h1>Последние файлы</h1>
               <ul>
               <li>{{ recentFiles() }}</li>
        </ul>
               <h1>Последние статьи</h1>
               <ul>
               <li>{{ recentBlogs() }}</li>
        </ul>
               <h1>Последние фотографии</h1>
               <ul>
               <li>{{  recentPhotos() }}</li>
           </ul>
</div>

    </div>

<div class="footer">
    <div class="copy"><a href="/">{{ setting('copy') }}</a></div>
    <div class="onlins"> @yield('online')</div>
    <div class="counter"> @yield('counter')</div> <!--class="counter" Для счетчиков сайта-->
    <div class="perf">@yield('performance')</div>
    
</div>


</div>

 
  

@yield('scripts')

@stack('scripts')

<script>
$(document).ready(function(){
    $("#toggler").click(function(){
        $("#box").toggle();
        
        
    });
    
});

    </script>

</body>
</html>
