@extends('layout')

@section('title')
    Панель управления
@stop

@section('content')

    <h1>Панель управления</h1>

    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item active">Панель</li>
        </ol>
    </nav>

   <div class="rversion">
    <div class="btns">
     <a class="btn" href="/admin/upgrade"><i class="fa fa-key fa-lg"></i> Версия {{ VERSION }}.{{ setting('buildversion') }}</a>
</div>
</div>

   <div class="user-menu">
   <ul>
    <div class="bl"><i class="fa fa-cog fa-lg text-muted"></i> <b>Редактор</b></div>
       <li><a href="/admin/chats">Админ-чат ({{ statsChat() }})</a></li>
    <li><a href="/admin/guestbooks">Гостевая книга ({{ statsGuestbook() }})</a></li> 
    <li><a href="/admin/forums">Форум ({{ statsForum() }})</a></li> 
    <li><a href="/admin/photos">Галерея ({{ statsPhotos() }})</a></li> 
    <li><a href="/admin/blogs">Блоги ({{ statsBlog() }})</a></li> 
    <li><a href="/admin/boards">Объявления ({{ statsBoard() }})</a></li> 
    <li><a href="/admin/reklama">Пользовательская реклама</a></li>

    @if (isAdmin('moder'))
        <div class="bl"><i class="fa fa-cog fa-lg text-muted"></i> <b>Модератор</b></div>
        <li><a href="/admin/bans">Бан / Разбан</a></li>
        <li><a href="/admin/banlists">Забаненные  ({{ statsBanned() }})</a></li>
        <li><a href="/admin/spam">Жалобы ({{ statsSpam() }})</a></li> 
        <li><a href="/admin/administrators">Администрация ({{ statsAdmins() }})</a></li> 
        <li><a href="/admin/reglists">Ожидающие ({{ statsRegList() }})</a></li> 
        <li><a href="/admin/votes">Голосования ({{ statVotes() }})</a></li> 
        <li><a href="/admin/antimat">Антимат  ({{ statsAntimat() }})</a></li>
        <li><a href="/admin/banhists">История банов ({{ statsBanHist() }})</a></li> 
        <li><a href="/admin/invitations">Приглашения ({{ statsInvite() }})</a></li> 
        <li><a href="/admin/transfers">Денежные операции</a></li>
    @endif

    @if (isAdmin('admin'))
        <div class="bl"><i class="fa fa-cog fa-lg text-muted"></i> <b>Администратор</b></div>
        <li><a href="/admin/rules">Правила сайта</a></li>
        <li><a href="/admin/news">Новости ({{ statsNews() }})</a></li> 
        <li><a href="/admin/ipbans">IP-бан панель ({{ statsIpBanned() }})</a></li> 
        <li><a href="/admin/phpinfo">PHP-информация ({{ parseVersion(PHP_VERSION) }})</a></li> 
        <li><a href="/admin/loads">Загруз-центр ({{ statsLoad() }})</a></li> 
        <li><a href="/admin/downs/new">Новые публикации ({{ statsNewLoad() }})</a></li> 
        <li><a href="/admin/errors">Ошибки / Автобаны</a></li>
        <li><a href="/admin/blacklists">Черный список ({{ statsBlacklist() }})</a></li> 
        <li><a href="/admin/offers">Предложения / Проблемы ({{ statsOffers() }})</a></li> 
        <li><a href="/admin/smiles">Смайлы ({{ statsSmiles() }})</a></li> 
        <li><a href="/admin/status">Статусы пользователей</a></li>
    @endif

    @if (isAdmin('boss'))
        <div class="bl"><i class="fa fa-cog fa-lg text-muted"></i> <b>Босс</b></div>
        <li><a href="/admin/settings">Настройки сайта</a></li>
        <li><a href="/admin/users">Пользователи ({{ statsUsers() }})</a></li> 
        <li><a href="/admin/caches">Очистка кэша</a></li>
        <li><a href="/admin/backups">Backup-панель</a></li>
        <li><a href="/admin/checkers">Сканирование сайта ({{ statsChecker() }})</a></li> 
        <li><a href="/admin/delivery">Приват-рассылка</a></li>
        <li><a href="/admin/logs">Логи посещений</a></li>
        <li><a href="/admin/notices">Шаблоны писем</a></li>
        <li><a href="/admin/files">Редактирование файлов</a></li>
        <li><a href="/admin/delusers">Чистка пользователей</a></li>
    @endif
       </ul>
</div>
    @if (! $existBoss)
        <div class="po-centru"><b><span style="color:#ff0000">Внимание!!! Отсутствует профиль суперадмина</span></b><br>
        В базе данных не найден пользователь с правами boss</div>
    @endif

    @if (file_exists(HOME.'/install'))
        <div class="po-centru"><b><span style="color:#ff0000">Внимание!!! Необходимо удалить директорию install</span></b><br>
        Наличие этой директории может нарушить безопасность сайта. Удалите ее прямо сейчас!</div>
    @endif
@stop
