@extends('layout')

@section('title')
    {{ $category->name }} (Стр. {{ $page->current }})
@stop

@section('content')


    <h1>{{ $category->name }} <small>(Статей: {{ $category->count_blogs }})</small></h1>

   <div class="blog-wrapp">
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item"><a href="/blogs">Блоги</a></li>

            @if ($category->parent->id)
                <li class="breadcrumb-item"><a href="/blogs/{{ $category->parent->id }}">{{ $category->parent->name }}</a></li>
            @endif

            <li class="breadcrumb-item active">{{ $category->name }}</li>

            @if (isAdmin())
                <li class="breadcrumb-item"><a href="/admin/blogs/{{ $category->id }}?page={{ $page->current }}">Управление</a></li>
            @endif
        </ol>
    </nav>

       @if (getUser() && ! $category->closed)
        <div class="btns">
            <a class="btn btn-success" href="/blogs/create?cid={{ $category->id }}">Добавить статью</a>
        </div>
    @endif
   
    @if ($blogs->isNotEmpty())
        @foreach ($blogs as $data)
           <div class="blog-nav">
            <ul class="end-link">
                <li><a href="/articles/{{ $data->id }}"><span class="icon"><img src="/themes/Whiteblack/img/article.png" alt="icon"></span>{{ $data->title }} ({!! formatNum($data->rating) !!})</a></li>
            </ul>
       </div>
            <!--<div>
                Автор: {!! $data->user->getProfile() !!} ({{ dateFixed($data->created_at) }})<br>
                Просмотров: {{ $data->visits }}<br>
                <a href="/articles/comments/{{ $data->id }}">Комментарии</a> ({{ $data->count_comments }})
                <a href="/articles/end/{{ $data->id }}">&raquo;</a>
            </div>-->
        @endforeach

        {!! pagination($page) !!}
    @else
        {!! showError('Статей еще нет, будь первым!') !!}
    @endif

   <div class="post-nav-link">
    <a href="/blogs/top">Топ статей</a>
    <a href="/blogs/tags">Облако тегов</a>
    <a href="/blogs/search">Поиск</a>
    <a href="/blogs/authors">Авторы</a>
</div>
</div>
@stop
