@extends('layout')

@section('title')
    Блоги - Список разделов
@stop

@section('content')



    <h1>Блоги</h1>
    
<div class="blog-wrapp">
   
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item active">Блоги</li>
        </ol>
    </nav>

    <div class="main-new-link">
    @if (getUser())
       <span>Мои: </span>
        <a href="/blogs/active/articles">статьи</a>
        <a href="/blogs/active/comments">комментарии</a>
    @endif

   <span> Новые:</span>
   <a href="/articles">статьи</a>
    <a href="/articles/comments">комментарии</a>
    </div>

    @if (getUser())
        <div class="btns">
            <a class="btn btn-success" href="/blogs/create">Добавить статью</a>
        </div>
    @endif
   
    @foreach ($categories as $key => $data)

       <div class="blog-nav">
        <ul>
         <li><a href="/blogs/{{ $data->id }}"><span class="icon"><img src="/themes/WhiteBlack/img/blogs.png" alt="icon"></span>{{ $data->name }}   @if ($data->new)
                ({{ $data->count_blogs }}/<span style="color:green">+{{ $data->new->count_blogs }}</span>)
            @else
                ({{ $data->count_blogs }})
            @endif</a></li>

        </ul>

    </div>
        <div>
            @if ($data->children->isNotEmpty())
                @foreach ($data->children as $child)
                    <i class="fa fa-angle-right"></i> <b><a href="/blogs/{{ $child->id }}">{{ $child->name }}</a></b>
                    @if ($child->new)
                        ({{ $child->count_blogs }}/<span style="color:#ff0000">+{{ $child->new->count_blogs }}</span>)
                    @else
                        ({{ $child->count_blogs }})
                    @endif
                @endforeach
            @endif
        </div>
    @endforeach

    <div class="post-nav-link">
    <a href="/blogs/top">Топ статей</a>
    <a href="/blogs/tags">Облако тегов</a>
    <a href="/blogs/search">Поиск</a>
    <a href="/blogs/authors">Авторы</a>
    <a href="/blogs/rss">RSS</a>
    </div>
    
    </div>
@stop
