@extends('layout')

@section('title')
    Блоги - Новые статьи (Стр. {{ $page->current }})
@stop

@section('content')

    <h1>Новые статьи</h1>

   <div class="blog-wrapp">
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item"><a href="/blogs">Блоги</a></li>
            <li class="breadcrumb-item active">Новые статьи</li>
        </ol>
    </nav>

    @if ($blogs->isNotEmpty())
        @foreach ($blogs as $data)
           <div class="blog-top">
            <ul>
                <li><a href="/articles/{{ $data->id }}"><span class="icon"><img src="/themes/WhiteBlack/img/new.png" alt="icon"></span>{{ $data->title }} ({!! formatNum($data->rating) !!})</a></li> 
            </ul>

            <div class="b-bottom">
                <a class="cats" href="/blogs/{{ $data->category_id }}">Категория:  {{ $data->category->name }}</a>
                <div class="author-wrapp">
                    <span>Добавил: {!! $data->user->getProfile() !!}  ({{  dateFixed($data->created_at) }})</span>
                    <span>Просмотров: {{ $data->visits }}</span>
                </div>
            </div>
       </div>
        @endforeach

        {!! pagination($page) !!}
    @else
        {!! showError('Опубликованных статей еще нет!') !!}
    @endif
</div>
@stop
