@extends('layout')

@section('title')
    Блоги - Новые комментарии (Стр. {{ $page->current }})
@stop

@section('content')

    <h1>Новые комментарии</h1>

   <div class="blog-wrapp">
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item"><a href="/blogs">Блоги</a></li>
            <li class="breadcrumb-item active">Новые комментарии</li>
        </ol>
    </nav>

    @if ($comments->isNotEmpty())
        @foreach ($comments as $data)
            <div class="new-main-comment">
                <ul>
                 <li>
                    <a href="/articles/comments/{{ $data->relate_id }}"><span class="icon"><i class="fa fa-comment"></i></span>{{ $data->title }} ({{ $data->count_comments }})</a></li>

                    <!--<div class="float-right">
                        @if (isAdmin())
                            <a href="#" onclick="return deleteComment(this)" data-rid="{{ $data->relate_id }}" data-id="{{ $data->id }}" data-type="{{ App\Models\Blog::class }}" data-token="{{ $_SESSION['token'] }}" data-toggle="tooltip" title="Удалить"><i class="fa fa-times text-muted"></i></a>
                        @endif
                    </div>-->
                </ul>

                <div class="comment-text"> {!! bbCode($data->text) !!}</div>
                   

                   <div class="news-bottom">
                    <span>Написал: {!! $data->user->getProfile() !!} <br> <small>({{ dateFixed($data->created_at) }})</small></span>
                    @if (isAdmin())
                        <span>({{ $data->brow }}, {{ $data->ip }})</span>
                    @endif
                </div>
                
            </div>
        @endforeach

        {!! pagination($page) !!}
    @else
        {!! showError('Комментарии не найдены!') !!}
    @endif
</div>
@stop
