@extends('layout')

@section('title')
    Топ статей (Стр. {{ $page->current }})
@stop

@section('content')

    <h1>Топ статей</h1>
 <div class="blog-wrapp">
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item"><a href="/blogs">Блоги</a></li>
            <li class="breadcrumb-item active">Топ статей</li>
        </ol>
    </nav>

   <div class="main-new-link">
    <span>Сортировать:</span>
    <?php $active = ($order === 'visits') ? 'success' : 'light'; ?>
    <a href="/blogs/top?sort=visits">Просмотры</a>

    <?php $active = ($order === 'rating') ? 'success' : 'light'; ?>
    <a href="/blogs/top?sort=rated">Оценки</a>

    <?php $active = ($order === 'count_comments') ? 'success' : 'light'; ?>
    <a href="/blogs/top?sort=comments">Комментарии</a>
     </div>

    @if ($blogs->isNotEmpty())
        @foreach ($blogs as $data)

           <div class="blog-top">
            <ul>
                <li><a href="/articles/{{ $data->id }}"><span class="icon"><img src="/themes/WhiteBlack/img/top.png" alt="icon"></span>{{ $data->title }} ({!! formatNum($data->rating) !!})</a></li> 
            </ul>

            <div class="b-bottom">
                <a class="cats" href="/blogs/{{ $data->category_id }}">Категория: {{ $data->name }}</a>
                
                <div class="author-wrapp">
                <span>Автор: {!! $data->user->getProfile() !!}</span>
                <span>Просмотров: {{ $data->visits }}</span>
                </div>
                
                <div class="end-comment">
                <a href="/articles/comments/{{ $data->id }}">Комментарии {{ $data->count_comments }}</a>
                <a href="/articles/end/{{ $data->id }}">&raquo;</a>
                </div>
            </div>
     </div>
        @endforeach

        {!! pagination($page) !!}
    @else
        {!! showError('Опубликованных статей еще нет!') !!}
    @endif
</div>
@stop
