@extends('layout')

@section('title')
    {{ $blog->title }}
@stop

@section('keywords')
    {{ $blog->tags }}
@stop

@section('description')
    {{ stripString($blog->text) }}
@stop

@section('content')



    <h1>{{ $blog->title }} <small>(Оценка: {!! formatNum($blog->rating) !!})</small></h1>
<div class="blog-wrapp">
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item"><a href="/blogs">Блоги</a></li>

            @if ($blog->category->parent->id)
                <li class="breadcrumb-item"><a href="/blogs/{{ $blog->category->parent->id }}">{{ $blog->category->parent->name }}</a></li>
            @endif
            <li class="breadcrumb-item"><a href="/blogs/{{ $blog->category_id }}">{{ $blog->category->name }}</a></li>
            <li class="breadcrumb-item active">{{ $blog->title }}</li>
        </ol>
    </nav>

   <div class="post-nav-link">
    <a href="/articles/print/{{ $blog->id }}">Печать</a>
    <a href="/articles/rss/{{ $blog->id }}">RSS-лента</a>

    @if (isAdmin())
        <a href="/admin/articles/edit/{{ $blog->id }}">Редактировать</a>
        <a href="/admin/articles/move/{{ $blog->id }}">Перенести</a>
        <a href="/admin/articles/delete/{{ $blog->id }}?token={{ $_SESSION['token'] }}" onclick="return confirm('Вы действительно хотите удалить данную статью?')">Удалить</a>
    @endif
    </div>
 @if ($blog->user->id == getUser('id'))
        <div class="btns">
            <a class="btn btn-success" href="/articles/edit/{{ $blog->id }}">Изменить</a>
        </div>
    @endif
   
   <div class="blog-view">
   <div class="blog-view-text">
    {!! $blog->text !!}
       </div>

    @if ($page->total > 1)
        {!! pagination($page) !!}
    @endif

   <div class="view-author">
      <span><i class="fa fa-eye"></i> {{ $blog->visits }}</span>
       <span>Автор статьи: {!! $blog->user->getProfile() !!} ({{ dateFixed($blog->created_at) }})</span>
       </div>

   
   <div class="view-tags">
       <span><i class="fa fa-tag"></i></span> {!! $tags !!}
       </div>

    <div class="js-rating">
       <span class="rats">Рейтинг:</span>
        @unless (getUser('id') == $blog->user_id)
            <a class="red" class="post-rating-down<?= $blog->vote == '-' ? ' active' : '' ?>" href="#" onclick="return changeRating(this);" data-id="{{ $blog->id }}" data-type="{{ App\Models\Blog::class }}" data-vote="-" data-token="{{ $_SESSION['token'] }}"><i class="fa fa-thumbs-down"></i></a>
        @endunless
        <span>{!! formatNum($blog->rating) !!}</span>
        @unless (getUser('id') == $blog->user_id)
            <a class="post-rating-up<?= $blog->vote == '+' ? ' active' : '' ?>" href="#" onclick="return changeRating(this);" data-id="{{ $blog->id }}" data-type="{{ App\Models\Blog::class }}" data-vote="+" data-token="{{ $_SESSION['token'] }}"><i class="fa fa-thumbs-up"></i></a>
        @endunless
    </div>

    <div class="post-nav-link">
     <a href="/articles/comments/{{ $blog->id }}"><i class="fa fa-comment"></i> Комментарии ({{  $blog->count_comments }})</a> 
    <a href="/articles/end/{{ $blog->id }}">&raquo;</a>
       </div>
    </div>
</div>
@stop
