@extends('layout')

@section('title')
    Форум
@stop

@section('content')


    <h1>Форум {{ setting('title') }}</h1>
<div class="forum-wrapp">
    @include('advert/_forum')

    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item active">Форум</li>
        </ol>
    </nav>

   <div class="main-new-link">
    @if (getUser())
       <span>Мои:</span>
        <a href="/forums/active/topics">темы</a>
        <a href="/forums/active/posts">сообщения</a>
        <a href="/forums/bookmarks">закладки</a>
    @endif

   <span>Новые:</span>
    <a href="/topics">темы</a><a href="/posts">сообщения</a>
    </div>
 @if (getUser())
        <div class="btns">
            <a class="btn btn-success" href="/forums/create">Создать тему</a>
        </div>
    @endif
    @if ($forums->isNotEmpty())
        @foreach ($forums as $forum)
           <div class="forum">
            <ul>
                
                <li><a href="/forums/{{ $forum->id }}"><span class="icon"><img src="/themes/WhiteBlack/img/speech-bubble.png" alt="icon"></span> {{ $forum->title }} ({{ $forum->count_topics }}/{{ $forum->count_posts }})</a></li>
                

                @if ($forum->description)
                    <p><small>{{ $forum->description }}</small></p>
                @endif
    </ul>

            <!--<div>
                @if ($forum->children->isNotEmpty())
                    @foreach ($forum->children as $child)
                        <i class="fa fa-copy text-muted"></i> <b><a href="/forums/{{ $child->id }}">{{ $child->title }}</a></b>
                        ({{ $child->count_topics }}/{{ $child->count_posts }})<br/>
                    @endforeach
                @endif

                @if ($forum->lastTopic->lastPost->id)
                    Тема: <a href="/topics/end/{{ $forum->lastTopic->id }}">{{ $forum->lastTopic->title }}</a>
                    <br/>
                    Сообщение: {!! $forum->lastTopic->lastPost->user->getProfile(null, false) !!} ({{ dateFixed($forum->lastTopic->lastPost->created_at) }})
                @else
                    Темы еще не созданы!
                @endif
                </div>-->
            </div>
        @endforeach
    @else
        {!! showError('Разделы форума еще не созданы!') !!}
    @endif

    <div class="post-nav-link">
    <a href="/rules">Правила</a>
    <a href="/forums/top/topics">Топ тем</a>
    <a href="/forums/top/posts">Топ постов</a>
    <a href="/forums/search">Поиск</a>
    <a href="/forums/rss">RSS</a>
    </div>
    
    </div>
@stop
