@extends('layout')

@section('title')
    Форум - Новые сообщения (Стр. {{ $page->current }})
@stop

@section('content')
    <h1>Новые сообщения</h1>
<div class="forum-wrapp">
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item"><a href="/forums">Форум</a></li>
            <li class="breadcrumb-item active">Новые сообщения</li>
        </ol>
    </nav>

    @foreach ($posts as $data)
       <div class="new-themes-post">
        <ul>
            <li><a href="/topics/{{ $data->topic_id }}/{{ $data->id }}"><span class="icon"><img src="/themes/WhiteBlack/img/new.png" alt="icon"></span>{{ $data->topic->title }}  ({{ $data->topic->count_posts }})</a></li>
        </ul>
       
           <div class="forum-text">
            {!! bbCode($data->text) !!}
            </div>

           <div class="news-bottom">
           <span>Написал: {{ $data->user->login }} <br><small>({{ dateFixed($data->created_at) }})</small></span>
            

            @if (isAdmin())
                <span>({{ $data->brow }}, {{ $data->ip }})</span>
            @endif
</div>
        </div>
    @endforeach

    {!! pagination($page) !!}
    </div>
@stop
