@extends('layout')

@section('title')
    Форум - Новые темы (Стр. {{ $page->current }})
@stop

@section('content')
    <h1>Новые темы</h1>
<div class="forum-wrapp">
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item"><a href="/forums">Форум</a></li>
            <li class="breadcrumb-item active">Новые темы</li>
        </ol>
    </nav>

    @foreach ($topics as $data)
       <div class="new-themes-post">
        <ul>
            <li><a href="/topics/{{ $data->id }}"><span class="icon"><img src="/themes/WhiteBlack/img/new.png" alt="icon"></span>{{ $data->title }} ({{ $data->count_posts }})</a></li> 
        </ul>

        <div class="forum-pagist">
           <div class="p">{!! $data->pagination() !!}</div>
            <a class="f" href="/forums/{{  $data->forum->id }}">Форум:  {{  $data->forum->title }}</a>
            
            
           </div>
            
            <div class="news-bottom">
            <span>Автор: {!! $data->user->getProfile(null, false) !!} / Посл.: {!! $data->lastPost->user->getProfile(null, false) !!} ({{ dateFixed($data->created_at) }})
            </span>
            </div>
       
</div>
    @endforeach

    {!! pagination($page) !!}
    </div>
@stop
