@extends('layout')

@section('title')
    Топ популярных тем
@stop

@section('content')

    <h1>Топ популярных тем</h1>
<div class="forum-wrapp">
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item"><a href="/forums">Форум</a></li>
            <li class="breadcrumb-item active">Топ популярных тем</li>
        </ol>
    </nav>

    @if ($topics->isNotEmpty())
        @foreach ($topics as $data)
           <div class="new-themes-post">
            <ul>
                <li><a href="/topics/{{ $data->id }}"><span class="icon"><img src="/themes/WhiteBlack/img/top.png" alt="icon"></span>{{ $data->title }}  ({{ $data->count_posts }})</a></li> 
            </ul>
           
               <div class="forum-pagist">
               <div class="p">
                {!! $data->pagination() !!}
                </div>
                </div>
                
                <div class="news-bottom">
                    <span>Сообщение: {!! $data->lastPost->user->getProfile(null, false) !!} <br> ({{ dateFixed($data->lastPost->created_at) }})</span>
                    <span>Автор: {!! $data->user->getProfile(null, false) !!}</span>
                </div>
                
               
            
            </div>
        @endforeach

        {!! pagination($page) !!}
    @else
        {!! showError('Созданных тем еще нет!') !!}
    @endif
    </div>
@stop
