@extends('layout')

@section('title')
    Топ популярных постов
@stop

@section('content')
    <h1>Топ популярных постов</h1>
<div class="forum-wrapp">
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item"><a href="/forums">Форум</a></li>
            <li class="breadcrumb-item active">Топ популярных постов</li>
        </ol>
    </nav>

   <div class="main-new-link">
   <span>Период:</span>
    <?php $active = ($period == 1) ? 'success' : 'light'; ?>
    <a href="/forums/top/posts?period=1">Сутки</a>

    <?php $active = ($period == 7) ? 'success' : 'light'; ?>
    <a href="/forums/top/posts?period=7" >Неделя</a>

    <?php $active = ($period == 30) ? 'success' : 'light'; ?>
    <a href="/forums/top/posts?period=30">Месяц</a>

    <?php $active = ($period == 365) ? 'success' : 'light'; ?>
    <a href="/forums/top/posts?period=365" >Год</a>

    <?php $active = (empty($period)) ? 'success' : 'light'; ?>
    <a href="/forums/top/posts" >За все время</a>
    </div>

    @if ($posts->isNotEmpty())
        @foreach ($posts as $data)
           <div class="new-themes-post">
            <ul>
                <li><a href="/topics/{{ $data->topic_id }}/{{ $data->id }}"><span class="icon"><img src="/themes/WhiteBlack/img/top.png" alt="icon"></span>{{ $data->topic->title }} (Рейтинг: {{ $data->rating }})</a></li>
                
            </ul>
           
               <div class="forum-text">
                {!! bbCode($data->text) !!}
                </div>

               <div class="news-bottom">
               <span>Написал: {{ $data->user->login }} <br><small>({{ dateFixed($data->created_at) }})</small></span>

                @if (isAdmin())
                    <span>({{ $data->brow }}, {{ $data->ip }})</span>
                @endif
              </div>
            </div>
        @endforeach

        {!! pagination($page) !!}
    @else
        {!! showError('Сообщений еще нет!') !!}
    @endif
    </div>
@stop
