@extends('layout')

@section('title')
    {{ trans('ignores.title') }}
@stop

@section('content')

    <h1>{{ trans('ignores.title') }}</h1>
<div class="privat-wrapp">
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item"><a href="/menu">{{ trans('common.menu') }}</a></li>
            <li class="breadcrumb-item active">{{ trans('ignores.title') }}</li>
        </ol>
    </nav>

    @if ($ignores->isNotEmpty())

        <form action="/ignores/delete?page={{ $page->current }}" method="post">
            <input type="hidden" name="token" value="{{ $_SESSION['token'] }}">

            @foreach ($ignores as $data)
               <div class="post">
                <div class="b">

                    <div class="float-right">
                        <a href="/messages/send?user={{ $data->ignoring->login }}" data-toggle="tooltip" title="{{ trans('ignores.write') }}"><i class="fa fa-reply text-muted"></i></a>
                        <a href="/ignores/note/{{ $data->id }}" data-toggle="tooltip" title="{{ trans('ignores.note') }}"><i class="fa fa-sticky-note text-muted"></i></a>
                        <input type="checkbox" name="del[]" value="{{ $data->id }}">
                    </div>

                    <div class="img">
                        {!! $data->ignoring->getAvatar() !!}
                        {!! $data->ignoring->getOnline() !!}
                    </div>

                    <b>{!! $data->ignoring->getProfile() !!}</b> <small>({{ dateFixed($data->created_at) }})</small><br>
                    {!! $data->ignoring->getStatus() !!}
                </div>
            </div>

                <div class="notes">
                    @if ($data->text)
                        {{ trans('ignores.note') }}: {!! bbCode($data->text) !!}<br>
                    @endif
                </div>
            @endforeach

            <div class="btns">
                <button class="btn btn-sm btn-danger">{{ trans('common.delete_selected') }}</button>
            </div>
        </form>

        {!! pagination($page) !!}

       <div class="tex-center">
           <span>{{ trans('ignores.total') }}: <b>{{ $page->total }}</b></span>
    </div>
    @else
       <div class="tex-center">
           <span>{!! showError(trans('ignores.empty_list')) !!}</span>
    </div>
    @endif

    <div class="form my-3">
        <form method="post">
            <input type="hidden" name="token" value="{{ $_SESSION['token'] }}">
            <div class="input-group{{ hasError('user') }}">
                <div class="input-group-prepend">
                    <span class="input-group-text"><i class="fa fa-pencil-alt"></i></span>
                </div>

                <input type="text" class="form-control" id="user" name="user" maxlength="20" value="{{ getInput('user') }}" placeholder="{{ trans('ignores.user_login') }}" required>

                <span class="input-group-btn">
                    <button class="btn btn-primary">{{ trans('ignores.add') }}</button>
                </span>
            </div>
            {!! textError('user') !!}
        </form>
    </div>
<div class="privat-nav">
   <ul>
      <li><a href="/contacts"><span class="icon"><i class="fa fa-users"></i></span>{{ trans('ignores.contacts') }}</a></li>
     <li><a href="/messages"><span class="icon"><i class="fa fa-envelope"></i></span>{{ trans('ignores.messages') }}</a></li>
    </ul>
    </div>
</div>
@stop
