@extends('layout')

@section('title')
    Загрузки - Список комментариев {{ $user->login }} (Стр. {{ $page->current }})
@stop

@section('content')

    <h1>Комментарии {{ $user->login }}</h1>
<div class="down-wrapp">
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item"><a href="/loads">Загрузки</a></li>
            <li class="breadcrumb-item active">Комментарии {{ $user->login }}</li>
        </ol>
    </nav>

    @if ($comments->isNotEmpty())
        @foreach ($comments as $data)
            <div class="down-new-main-comment">
                <ul>
                    <li><a href="/downs/comment/{{ $data->relate_id }}/{{ $data->id }}"><span class="icon"> <i class="fa fa-comment"></i></span>{{ $data->title }} ({{ $data->count_comments }})</a></li> 

                    <!--<div class="float-right">
                        @if (isAdmin())
                            <a href="#" onclick="return deleteComment(this)" data-rid="{{ $data->relate_id }}" data-id="{{ $data->id }}" data-type="{{ App\Models\Down::class }}" data-token="{{ $_SESSION['token'] }}" data-toggle="tooltip" title="Удалить"><i class="fa fa-times text-muted"></i></a>
                        @endif
                    </div>-->
                </ul>

               
                   <div class="down-text">{!! bbCode($data->text) !!}</div>
                    

                   <div class="news-bottom">
                    <span>Написал: {!! $data->user->getProfile() !!} <br>({{ dateFixed($data->created_at) }})</span>
                    @if (isAdmin())
                        <span>({{ $data->brow }}, {{ $data->ip }})</span>
                    @endif
               </div>
            </div>
        @endforeach

        {!! pagination($page) !!}
    @else
        {!! showError('Комментарии не найдены!') !!}
    @endif
    </div>
@stop
