@extends('layout')

@section('title')
    Загрузки
@stop

@section('content')

    <h1>Загрузки</h1>
<div class="down-wrapp">
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item active">Загрузки</li>
        </ol>
    </nav>

   <div class="main-new-link">
    @if (getUser())
       <span>Мои:</span>
        <a href="/downs/active/files">файлы</a>
        <a href="/downs/active/comments">комментарии</a>
    @endif

   <span>Новые:</span>
     <a href="/downs">файлы</a>
    <a href="/downs/comments">комментарии</a>
    </div>

    @if (getUser())
        <div class="btns">
            <a class="btn btn-success" href="/downs/create">Добавить файл</a>
        </div>
    @endif
   
    @foreach ($categories as $category)
        <ul>
            <li><a href="/loads/{{ $category->id }}"><span class="icon"><img src="/themes/WhiteBlack/img/white-folder.png" alt="icon"></span>{{ $category->name }}  @if ($category->new)
                ({{ $category->count_downs }}/<span style="color:limegreen">+{{ $category->new->count_downs }}</span>)
            @else
                ({{ $category->count_downs }})
            @endif</a></li>
           
        </ul>

        <div>
           <ul>
            @if ($category->children->isNotEmpty())
                @foreach ($category->children as $child)
                     <li class="catis"><a href="/loads/{{ $child->id }}"><span class="icon"><img src="/themes/WhiteBlack/img/right-drawn-arrow.png" alt="icon"></span>{{ $child['name'] }} @if ($child->new)
                        ({{ $child->count_downs }}/<span style="color:#ff0000">+{{ $child->new->count_downs }}</span>)<br>
                    @else
                        ({{ $child->count_downs }})<br>
                    @endif
                         @endforeach</a></li>
                    
            @endif
            </ul>
        </div>
    @endforeach

    <div class="post-nav-link">
    <a href="/loads/top">Топ файлов</a>
    <a href="/loads/search">Поиск</a>
    <a href="/loads/rss">RSS</a>
    </div>
    </div>
@stop
