@extends('layout')

@section('title')
    {{ $category->name }} (Стр. {{ $page->current }})
@stop

@section('content')


    <h1>{{ $category->name }}</h1>
    
<div class="down-wrapp">
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item"><a href="/loads">Загрузки</a></li>

            @if ($category->parent->id)
                <li class="breadcrumb-item"><a href="/loads/{{ $category->parent->id }}">{{ $category->parent->name }}</a></li>
            @endif

            <li class="breadcrumb-item active">{{ $category->name }}</li>

            @if (isAdmin('admin'))
                <li class="breadcrumb-item"><a href="/admin/loads/{{ $category->id }}?page={{ $page->current }}">Управление</a></li>
            @endif
        </ol>
    </nav>

   <div class="main-new-link">
   
    <span> Сортировать:</span>

    <?php $active = ($order === 'created_at') ? 'success' : 'light'; ?>
    <a href="/loads/{{ $category->id }}?sort=time">По дате</a>

    <?php $active = ($order === 'loads') ? 'success' : 'light'; ?>
    <a href="/loads/{{ $category->id }}?sort=loads">Скачивания</a>

    <?php $active = ($order === 'rated') ? 'success' : 'light'; ?>
    <a href="/loads/{{ $category->id }}?sort=rated">Оценки</a>

    <?php $active = ($order === 'count_comments') ? 'success' : 'light'; ?>
    <a href="/loads/{{ $category->id }}?sort=comments">Комментарии</a>
    </div>

      @if (getUser() && ! $category->closed)
        <div class="btns">
            <a class="btn btn-success" href="/downs/create?cid={{ $category->id }}">Добавить файл</a>
        </div>
    @endif
   
    @if ($category->children->isNotEmpty() && $page->current == 1)
        <ul>
            @foreach ($category->children as $child)
                <li>
                    <a href="/loads/{{ $child->id }}"><span class="icon"><img src="/themes/WhiteBlack/img/white-folder.png" alt="icon"></span>{{ $child->name }} ({{ $child->count_downs }})</a> </li>
            @endforeach
        </ul>
       
    @endif

    @if ($downs->isNotEmpty())
        @foreach ($downs as $data)
            <?php $rating = $data->rated ? round($data->rating / $data->rated, 1) : 0; ?>

            <ul>
                <li><a href="/downs/{{ $data->id }}"><span class="icon"><img src="/themes/WhiteBlack/img/down.png" alt="icon"></span>{{ $data->title }} ({{ $data->count_comments }})</a></li> 
            </ul>

            <!--<div>
                Рейтинг: {{ $rating }}<br>
                Скачиваний: {{ $data->loads }}<br>
                <a href="/downs/comments/{{ $data->id }}">Комментарии</a> ({{ $data->count_comments }})
                <a href="/downs/end/{{ $data->id }}">&raquo;</a>
            </div>-->
        @endforeach

        {!! pagination($page) !!}
    @else
        @if (! $category->closed)
            {!! showError('В данной категории еще нет файлов!') !!}
        @endif
    @endif

    @if ($category->closed)
        {!! showError('В данной категории запрещена загрузка файлов!') !!}
    @endif

   <div class="post-nav-link">
       <a href="/loads/top">Топ файлов</a>
    <a href="/loads/search">Поиск</a>
    </div>
    </div>
@stop
