@extends('layout')

@section('title')
    Поиск запроса {{ $find }}
@stop

@section('content')
    <h1>Поиск запроса {{ $find }}</h1>
<div class="down-wrapp">
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item"><a href="/loads">Загрузки</a></li>
            <li class="breadcrumb-item"><a href="/loads/search">Поиск</a></li>
            <li class="breadcrumb-item active">Поиск запроса</li>
        </ol>
    </nav>

   <div class="tx-center">Найдено совпадений в описании: <b>{{ $page->total }}</b></div>


    @foreach ($downs as $data)
        <?php $rating = $data->rated ? round($data->rating / $data->rated, 1) : 0; ?>

        <div class="new-main-files">
        <ul>
            <li><a href="/downs/{{ $data->id }}"><span class="icon"><i class="fa fa-file"></i></span>{{ $data->title }} ({{ $data->count_comments }})</a></li> 
        </ul>
           <div class="tx">{!! $data->cutText() !!}</div>
            
            <div class="new-main-bottom">
            <span class="links"><a href="/loads/{{ $data->category->id }}">Категория: {{ $data->category->name }}</a></span>
                <span>Рейтинг: {{ $rating }}</span>
                <span>Добавил: {!! $data->user->getProfile() !!} ({{ dateFixed($data->created_at) }})</span>
            </div>
        
    </div>
    @endforeach

    {!! pagination($page) !!}
    </div>
@stop
