@extends('layout')

@section('title')
    Топ популярных файлов (Стр. {{ $page->current }})
@stop

@section('content')

    <h1>Топ популярных файлов</h1>
<div class="down-wrapp">
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item"><a href="/loads">Загрузки</a></li>
            <li class="breadcrumb-item active">Топ файлов</li>
        </ol>
    </nav>

   <div class="main-new-link">
    <span> Сортировать:</span>
    <?php $active = ($order === 'loads') ? 'success' : 'light'; ?>
    <a href="/loads/top?sort=loads">Скачивания</a>

    <?php $active = ($order === 'rated') ? 'success' : 'light'; ?>
    <a href="/loads/top?sort=rated">Оценки</a>

    <?php $active = ($order === 'count_comments') ? 'success' : 'light'; ?>
    <a href="/loads/top?sort=comments">Комментарии</a>
   </div>

    @if ($downs->isNotEmpty())

        @foreach ($downs as $data)
            <?php $rating = $data->rated ? round($data->rating / $data->rated, 1) : 0; ?>

           <div class="top-files">
            <ul>
                <li>
                <a href="/downs/{{ $data->id }}"><span class="icon"><img src="/themes/WhiteBlack/img/top.png" alt="icon"></span>{{ $data->title }} ({{ $data->count_comments }})</a></li> 
            </ul>


               <div class="bottom-top-files">
               <span class="links"> <a href="/loads/{{ $data->category->id }}">Категория:  {{ $data->category->name }}</a></span>
                <span>Рейтинг: {{ $rating }}</span>
                <span>Скачиваний: {{ $data->loads }}</span>
                </div>
                
                <div class="top-files-comment">
                <a href="/downs/comments/{{ $data->id }}">Комментарии {{ $data->count_comments }}</a> 
                <a href="/downs/end/{{ $data->id }}">&raquo;</a>
               </div>
            
        </div>
        @endforeach

        {!! pagination($page) !!}
    @else
        @if (! $category->closed)
            {!! showError('Файлы не найдены!') !!}
        @endif
    @endif
    </div>
@stop
