@extends('layout')

@section('title')
    История переписки
@stop

@section('content')

    <h1>История переписки</h1>
<div class="privat-wrapp">
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item"><a href="/menu">Мое меню</a></li>
            <li class="breadcrumb-item"><a href="/messages">Приватные сообщения</a></li>
            <li class="breadcrumb-item active">История переписки</li>
        </ol>
    </nav>

   <div class="privat-message">
    <a href="/messages"><i class="fa fa-envelope"></i> Входящие</a>
    <a href="/messages/outbox"><i class="fa fa-paper-plane" aria-hidden="true"></i> Отправленные</a>
    </div>

    @if ($messages->isNotEmpty())

        @foreach ($messages as $data)
           <div class="post">
            <div class="b">
                <div class="img">
                    {!! $data->author->getAvatar() !!}
                    {!! $data->author->getOnline() !!}
                </div>

                <b>{!! $data->author->getProfile() !!}</b>
                ({{  dateFixed($data->created_at) }})
            </div>
            <div class="message">{!! bbCode($data->text) !!}</div>
    </div>
        @endforeach

        {!! pagination($page) !!}

    @else
        {!! showError('История переписки отсутствует!') !!}
    @endif

    <div class="form">
        <form action="/messages/send?user={{ $user->login }}" method="post">
            <input type="hidden" name="token" value="{{ $_SESSION['token'] }}">

            <label for="msg">Сообщение:</label>
            <textarea class="form-control markItUp" id="msg" rows="5" name="msg" placeholder="Текст сообщения" required></textarea>

            @if (getUser('point') < setting('privatprotect'))
                {!! view('app/_captcha') !!}
            @endif

            <button class="btn btn-primary">Быстрый ответ</button></form></div>

   <div class="tex-center">
       <span>Всего писем: <b>{{ $page->total }}</b></span>
</div>

   <div class="privat-nav">
   <ul>
       <li><a href="/searchusers"><span class="icon"><i class="fa fa-search"></i></span>Поиск контактов</a></li>
       <li><a href="/messages/send"><span class="icon"><i class="fa fa-envelope"></i></span>Написать письмо</a></li>
       <li><a href="/contacts"><span class="icon"><i class="fa fa-address-book"></i></span>Контакт</a></li>
       <li><a href="/ignores"><span class="icon"><i class="fa fa-ban" aria-hidden="true"></i></span>Игнор</a></li>
      
       </ul>
</div>
</div>
@stop
