@extends('layout')

@section('title')
    Отправленные сообщения
@stop

@section('content')

    <h1>Отправленные сообщения</h1>
<div class="privat-wrapp">
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item"><a href="/menu">Мое меню</a></li>
            <li class="breadcrumb-item active">Отправленные</li>
        </ol>
    </nav>

   <div class="privat-message">
       <a href="/messages"><i class="fa fa-envelope"></i> Входящие <b>{{ $page->totalInbox }}</b></a>
    <span class="active"><i class="fa fa-paper-plane" aria-hidden="true"></i> Отправленные <b>{{ $page->total }}</b></span>
    </div>

    @if ($messages->isNotEmpty())
        <form action="/messages/delete?type=outbox&amp;page={{ $page->current }}" method="post">
            <input type="hidden" name="token" value="{{ $_SESSION['token'] }}">
            <div class="form">
                <input type="checkbox" id="all" onchange="var o=this.form.elements;for(var i=0;i&lt;o.length;i++)o[i].checked=this.checked"> <b><label for="all">Отметить все</label></b>
            </div>

            @foreach ($messages as $data)
               <div class="post">
                <div class="b">
                    <div class="img">
                        {!! $data->recipient->getAvatar() !!}
                        {!! $data->recipient->getOnline() !!}
                    </div>

                    <b>{!! $data->recipient->getProfile() !!}</b>  ({{ dateFixed($data->created_at) }})<br>
                    {!! $data->recipient->getStatus() !!}
                </div>

                <div class="message">{!! bbCode($data->text) !!}
                   </div>

                   <div class="history">
                    <input type="checkbox" name="del[]" value="{{ $data->id }}">
                    <a href="/messages/send?user={{ $data->recipient->login }}">Написать еще</a>
                    <a href="/messages/history?user={{ $data->recipient->login }}">История</a></div>
                   
            </div>
            @endforeach

           <div class="btns">
            <button class="btn btn-sm">Удалить выбранное</button>
            </div>
        </form>

        {!! pagination($page) !!}

       <div class="tex-center">
          <span> Всего писем: <b>{{ $page->total }}</b></span>
   <span>Объем ящика: <b>{{ setting('limitmail') }}</b></span>
    </div>

       <div class="privat-nav">
       <ul>
       <li><a href="/messages/clear?type=outbox&amp;token={{ $_SESSION['token'] }}"><span class="icon"><i class="fa fa-times"></i></span>Очистить ящик</a></li>
    @else
        {!! showError('Отправленных писем еще нет!') !!}
    @endif

           <li><a href="/searchusers"><span class="icon"><i class="fa fa-search"></i></span>Поиск контактов</a></li>
           <li><a href="/messages/send"><span class="icon"><i class="fa fa-envelope"></i></span>Написать письмо</a></li>
           <li><a href="/contacts"><span class="icon"><i class="fa fa-address-book"></i></span>Контакт</a></li>
           <li><a href="/ignores"><span class="icon"><i class="fa fa-ban" aria-hidden="true"></i></span>Игнор</a></li>
           </ul>
    </div>
    
</div>
@stop
