@extends('layout')

@section('title')
    {{ trans('news.last_comments') }}
@stop

@section('content')

    <h1>{{ trans('news.last_comments') }}</h1>
<div class="news-wrapp">
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item"><a href="/news">{{ trans('news.header') }}</a></li>
            <li class="breadcrumb-item active">{{ trans('news.last_comments') }}</li>
        </ol>
    </nav>

    @if ($comments->isNotEmpty())
        @foreach ($comments as $data)
            <div class="news">
                <ul>
                <li><a href="/news/comment/{{ $data->relate_id }}/{{ $data->id }}"><span class="icon"><i class="fa fa-comment"></i></span> {{ $data->title }}  ({{ $data->count_comments }})</a>
                </li>
                 </ul>
            

            <div class="news-text">
                {!! bbCode($data->text) !!}
                 </div>
                 <div class="news-bottom">
                     <span>{{ trans('news.posted_by') }}: {!! $data->user->getProfile() !!} <br>({{ dateFixed($data->created_at) }})</span>
                 

                @if (isAdmin())
                    <span class="data">({{ $data->brow }}, {{ $data->ip }})</span>
                @endif
               </div>
            </div>
           
        @endforeach
 
        {!! pagination($page) !!}
    @else
        {!! showError(trans('news.empty_comments')) !!}
    @endif
    </div>
@stop
