@extends('layout')

@section('title')
    {{ trans('news.title', ['page' => $page->current]) }}
@stop

@section('content')

    <h1>{{ trans('news.header') }}</h1>
<div class="news-wrapp">
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item active">{{ trans('news.header') }}</li>

            @if (isAdmin('moder'))
                <li class="breadcrumb-item"><a href="/admin/news">{{ trans('common.management') }}</a></li>
            @endif
        </ol>
    </nav>
    @if ($news->isNotEmpty())
        @foreach ($news as $data)
          
           <div class="news">
           
           <ul>
                
                <li><a href="/news/{{ $data->id }}"><span class="icon"><i class="fa fa-file-alt fa-lg text-muted"></i></span>{{ $data->title }} </a></li>
           </ul>
            

           <div class="news-text">
            @if ($data->image)
                <div class="img">
                    <a href="{{ $data->image }}">{!! resizeImage($data->image, ['width' => 100, 'alt' => $data->title]) !!}</a>
                </div>
            @endif

            {!! bbCode($data->shortText()) !!}
            
            </div>
            <div class="news-bottom">
               <span>
                   {{ trans('news.added_by') }}: {!! $data->user->getProfile() !!}<br>
                ({{ dateFixed($data->created_at) }})
               </span>
                
                <span class="comment">
                    <a href="/news/comments/{{ $data->id }}"><i class="fa fa-comment"></i><span class="count">{{ $data->count_comments }}</span></a> 
                <!--<a href="/news/end/{{ $data->id }}">&raquo;</a>-->
                </span>
                
            </div>
             </div>
        @endforeach

        {!! pagination($page) !!}
    @else
        {!! showError(trans('news.empty_news')) !!}
    @endif

   <div class="news-end-block">
        <a href="/news/rss"><i class="fa fa-rss"></i> {{ trans('news.rss') }}</a>
     <a href="/news/allcomments"><i class="fa fa-comment"></i> {{ trans('news.last_comments') }}</a>
   </div>
    
   </div>
@stop
