@extends('layout')

@section('title')
    Предложения / Проблемы
@stop

@section('content')


    <h1>Предложения / Проблемы</h1>
<div class="offers-wrapp">
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item active">Предложения / Проблемы</li>

            @if (isAdmin('admin'))
                <li class="breadcrumb-item"><a href="/admin/offers/{{ $type }}?page={{ $page->current }}">Управление</a></li>
            @endif
        </ol>
    </nav>

   <div class="main-new-link">
       <span>Сортировать:</span>
    <?php $active = ($order === 'rating') ? 'success' : 'light'; ?>
    <a href="/offers/{{ $type }}?sort=rating">Голоса</a>

    <?php $active = ($order === 'created_at') ? 'success' : 'light'; ?>
    <a href="/offers/{{ $type }}?sort=time">Дата</a>

    <?php $active = ($order === 'status') ? 'success' : 'light'; ?>
    <a href="/offers/{{ $type }}?sort=status">Статус</a>

    <?php $active = ($order === 'count_comments') ? 'success' : 'light'; ?>
    <a href="/offers/{{ $type }}?sort=comments">Комментарии</a>
   </div>
    
     <div class="post-nav-link">
    @if ($type === 'offer')
        <a href="/offers/offer">Предложения <span class="badge badge-light">{{ $page->total }}</span></a>
        <a class="red" href="/offers/issue">Проблемы <span class="badge badge-light">{{ $page->otherTotal }}</span></a>
    @else
        <a href="/offers/offer">Предложения <span class="badge badge-light">{{ $page->otherTotal }}</span></a>
        <a class="red" href="/offers/issue">Проблемы <span class="badge badge-light">{{ $page->total }}</span></a>
    @endif
</div>
    
    
         @if (getUser())
           <div class="btns">
            <a class="btn btn-success" href="/offers/create?type={{ $type }}">Добавить</a>
             </div>
    @endif
   

    @if ($offers->isNotEmpty())

        @foreach ($offers as $data)
           <div class="offers">
            <ul>
                <li><a href="/offers/{{ $data->id }}"><span class="icon"><i class="fa fa-file"></i></span>{{ $data->title }}</a></li>
            </ul>
            <div class="statuses">
                <span>{!! $data->getStatus() !!}</span>
                <span>(Голосов: {{ $data->rating }})</span>
            </div>
            
           <div class="offers-text">{!! bbCode($data->text) !!}</div>
            
            <div class="news-bottom">
            <span>Добавлено: {!! $data->user->getProfile() !!} <br> ({{ dateFixed($data->created_at) }})</span>
            <span class="comment"><a href="/offers/comments/{{ $data->id }}"><span class="icon"><i class="fa fa-comment"></i></span><span class="count">
                {{ $data->count_comments }}
            </span></a></span>
            <!--<a href="/offers/end/{{ $data['id'] }}">&raquo;</a>-->
            </div>
            
            </div>
        @endforeach

        {!! pagination($page) !!}

        <div class="text-center">Всего записей: <b>{{ $page->total }}</b>
    </div>
    @else
        {!! showError('Записей еще нет!') !!}
    @endif
    
    </div>
@stop
