@extends('layout')

@section('title')
   {{ $offer->title }}
@stop

@section('content')

    <h1>{{ $offer->title }}</h1>
<div class="offers-wrapp">
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item"><a href="/offers/{{ $offer->type }}">Предложения / Проблемы</a></li>
            <li class="breadcrumb-item active">{{ $offer->title }}</li>

            @if (isAdmin('admin'))
                <li class="breadcrumb-item"><a href="/admin/offers/{{ $offer->id }}">Управление</a></li>
            @endif
        </ol>
    </nav>

    <div class="offers">
       
       <div class="statuses">
       <span>{!! $offer->getStatus() !!}</span>
       </div>


        @if (in_array($offer->status, ['wait', 'process']) && getUser('id') === $offer->user_id)
            <div class="float-right">
                <a title="Редактировать" href="/offers/edit/{{ $offer->id }}"><i class="fa fa-pencil-alt text-muted"></i></a>
            </div>
        @endif
    

    <div class="offers-text">{!! bbCode($offer->text) !!}</div>
       <div class="js-rating">
          <span class="rats">Рейтинг:</span>
            @unless (getUser('id') == $offer->user_id)
                <a class="red post-rating-down{{ $offer->vote == '-' ? ' active' : '' }}" href="#" onclick="return changeRating(this);" data-id="{{ $offer->id }}" data-type="{{ App\Models\Offer::class }}" data-vote="-" data-token="{{ $_SESSION['token'] }}"><i class="fa fa-thumbs-down"></i></a>
            @endunless
            <span>{!! formatNum($offer->rating) !!}</span>
            @unless (getUser('id') == $offer->user_id)
                <a class="post-rating-up{{ $offer->vote == '+' ? ' active' : '' }}" href="#" onclick="return changeRating(this);" data-id="{{ $offer->id }}" data-type="{{ App\Models\Offer::class }}" data-vote="+" data-token="{{ $_SESSION['token'] }}"><i class="fa fa-thumbs-up"></i></a>
            @endunless
        </div>

       <div class="news-bottom">
           <span>Добавлено: {!! $offer->user->getProfile() !!} <br> ({{ dateFixed($offer->created_at) }})</span>
       </div>
        

   </div>

    @if ($offer->reply)
        <div class="text-center"><b>Официальный ответ</b></div>
        <div class="q">
            {!! bbCode($offer->reply) !!}<br>
            {!! $offer->replyUser->getProfile() !!} ({{ dateFixed($offer->updated_at) }})
        </div>
    @endif

    <div class="offers-block-comment"><i class="fa fa-comment"></i> <b>Последние комментарии</b></div>

    @if ($offer->lastComments->isNotEmpty())

        @foreach ($offer->lastComments as $comment)
           <div class="post">
            <div class="b">
                <div class="img">
                    {!! $comment->user->getAvatar() !!}
                    {!! $comment->user->getOnline() !!}
                </div>

                <b>{!! $comment->user->getProfile() !!}</b>
                <small>({{ dateFixed($comment->created_at) }})</small><br>
                {!! $comment->user->getStatus() !!}
            </div>

           <div class="message">{!! bbCode($comment->text) !!}</div>
            
                @if (isAdmin())
                    <span class="data">({{ $comment->brow }}, {{ $comment->ip }})</span>
                @endif
            </div>
        @endforeach

        <div class="post-nav-link">
            <a href="/offers/comments/{{ $offer->id }}">Все комментарии {{ $offer->count_comments }}</a> 
            <a href="/offers/end/{{ $offer->id }}">&raquo;</a>
        </div>

    @else
        {!! showError('Комментариев еще нет!') !!}
    @endif

    @if (getUser())
        @if (! $offer->closed)
            <div class="form">
                <form action="/offers/comments/{{ $offer->id }}" method="post">
                    <input type="hidden" name="token" value="{{ $_SESSION['token'] }}">

                    <div class="form-group{{ hasError('msg') }}">
                        <label for="msg">Сообщение:</label>
                        <textarea class="form-control markItUp" id="msg" rows="5" name="msg" required>{{ getInput('msg') }}</textarea>
                        {!! textError('msg') !!}
                    </div>

                    <button class="btn btn-primary">Написать</button>
                </form>
            </div>
            <div class="post-nav-link">
            <a href="/rules">Правила</a>
            <a href="/smiles">Смайлы</a>
            <a href="/tags">Теги</a>
            </div>
        @else
            {!! showError('Комментирование данного предложения или проблемы закрыто!') !!}
        @endif
    @else
        {!! showError('Для добавления сообщения необходимо авторизоваться') !!}
    @endif
    </div>
@stop
