@extends('layout')

@section('title')
    Кто в онлайне
@stop

@section('content')

    <h1>Кто в онлайне</h1>
<div class="post-wrapp">
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item active">Кто в онлайне</li>
        </ol>
    </nav>

   <div class="tex-center"><span>Всего на сайте: <b>{{ $all }}</b></span><span> Авторизованных:  <b>{{ $total }}</b></span></div>
   


    @if ($online->isNotEmpty())

        @foreach ($online as $data)
           <div class="post">
            <div class="b">
                <div class="img">
                    {!! $data->user->getAvatar() !!}
                </div>

                <b>{!! $data->user->getProfile() !!}</b> (Время: {{ dateFixed($data['updated_at'], 'H:i:s') }})
            </div>

            @if (isAdmin())
                <div>
                    <span class="data">({{ $data['brow'] }}, {{ $data['ip'] }})</span>
                </div>
            @endif
</div>
        @endforeach
        {!! pagination($page) !!}
    @else
        {!! showError('Пользователей нет!') !!}
    @endif

    

   <div class="post-nav-link">
    @if ($guests)
        <a href="/online"><i class="fa fa-users"></i> Скрыть гостей</a>
    @else
        <a href="/online/all"><i class="fa fa-users"></i> Показать гостей</a>
    @endif
    </div>
</div>
@stop
