@extends('layout')

@section('title')
    Альбомы пользователей (Стр. {{ $page->current }})
@stop

@section('content')

    <h1>Альбомы пользователей</h1>
<div class="gallery-wrapp">
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item"><a href="/photos">Галерея</a></li>
            <li class="breadcrumb-item active">Альбомы пользователей</li>
        </ol>
    </nav>

    @if ($albums->isNotEmpty())
        @foreach ($albums as $data)
            <div class="gallery">

            <ul>
            <li><a href="/photos/albums/{{ $data->login }}"><span class="icon"><i class="fa fa-image"></i></span> {{ $data->login }} ({{ $data->cnt }} фото / {{ $data->count_comments }} комм.)</a></li> 
            </ul>
            </div>

        @endforeach

        {!! pagination($page) !!}

       <div class="vsego">
        Всего альбомов: <b>{{ $page->total }}</b>
    </div>
    @else
        {!! showError('Альбомов еще нет!') !!}
    @endif
    </div>
@stop
