@extends('layout')

@section('title')
    Список всех комментариев (Стр. {{ $page->current}})
@stop

@section('content')

    <h1>Список всех комментариев</h1>
<div class="gallery-wrapp">
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item"><a href="/photos">Галерея</a></li>
            <li class="breadcrumb-item active">Список всех комментариев</li>
        </ol>
    </nav>

    @if ($comments->isNotEmpty())
        @foreach ($comments as $data)
           <div class="gallery">
                <ul>
                    <li><a href="/photos/comment/{{ $data->relate_id }}/{{ $data->id }}"><span class="icon"><i class="fa fa-comment"></i></span>{{ $data->title }}</a></li>

                    <!--@if (isAdmin())
                        <a href="#" class="float-right" onclick="return deleteComment(this)" data-rid="{{ $data->relate_id }}" data-id="{{ $data->id }}" data-type="{{ App\Models\Photo::class }}" data-token="{{ $_SESSION['token'] }}" data-toggle="tooltip" title="Удалить"><i class="fa fa-times"></i></a>
                    @endif-->
                </ul>

               <div class="gallery-text">
                    {!! bbCode($data->text) !!}
                    </div>
                    
                    <div class="news-bottom">
                    <span>Написал: <b>{!! $data->user->getProfile() !!}</b><br><small>({{ dateFixed($data->created_at) }})</small></span>

                    @if (isAdmin())
                        <span>({{ $data->brow }}, {{ $data->ip }})</span>
                    @endif
                </div>
            
            </div>
        @endforeach

        {!! pagination($page) !!}

    @else
        {!! showError('Комментариев еще нет!') !!}
    @endif
    </div>
@stop
