@extends('layout')

@section('title')
    Анкета пользователя {{ $user->login }}
@stop

@section('content')

    <div class="avatar-box">
        <div class="avatar-box_image">{!! $user->getAvatar() !!}</div>
        <h1 class="avatar-box_login">
            {{ $user->login }} <small>#{{ $user->id }}</small>
        </h1>
    </div>

    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item active">Анкета {{ $user->login }}</li>
        </ol>
    </nav>

    @if ($user->level === 'pended')
        <b><span style="color:#ff0000">Внимание, аккаунт требует подтверждение регистрации!</span></b><br>
    @endif

    @if ($user->level === 'banned' && $user->timeban > SITETIME)
        <div class="form">
            <b><span style="color:#ff0000">Внимание, данный пользователь заблокирован!</span></b><br>
            До окончания бана: {{ formatTime($user->timeban - SITETIME) }}<br>

            @if ($user->lastBan->id)
                Причина: {!! bbCode($user->lastBan->reason) !!}<br>
            @endif
        </div>
    @endif

    @if (in_array($user->level, $adminGroups, true))
        <div class="alert alert-info">Должность: <b>{{ $user->getLevel() }}</b></div>
    @endif

        <div class="profil-block">
            <div class="p-block">
               <ul class="user-profil">
                   <li>Статус: <b><a href="/statusfaq">{!! $user->getStatus() !!}</a></b></li>

                
                
                <li>Пол: {!! $user->getGender() !!} {{  ($user->gender === 'male') ? 'Мужской' : 'Женский' }}</li>

                <li>Логин: <b>{{ $user->login }}</b></li>

                @if (! empty($user->name))
                   <li> Имя: <b>{{ $user->name }}<br></b></li>
                @endif

                @if (! empty($user->country))
                   <li> Страна: <b>{{ $user->country }}<br></b></li>
                @endif

                @if (! empty($user->city))
                   <li> Откуда: {{ $user->city }}</li>
                @endif

                @if (! empty($user->birthday))
                    <li>Дата рождения: {{ $user->birthday }}</li>
                @endif

                @if (! empty($user->phone))
                    <li>Телефон: {{ $user->phone }}</li>
                @endif

                @if (! empty($user->icq))
                    <li>ICQ: {{ $user->icq }}</li>
                @endif

                @if (! empty($user->skype))
                    <li>Skype: {{ $user->skype }}</li>
                @endif

                <li>Всего посeщений: {{ $user->visits }}</li>
                <li>Сообщений на форуме: {{ $user->allforum }}</li>
                <li>Сообщений в гостевой: {{ $user->allguest }}</li>
                <li>Комментариев: {{ $user->allcomments }}</li>
                <li>Актив: {{ plural($user->point, setting('scorename')) }}</li>
                <li>Денег: {{ plural($user->money, setting('moneyname')) }}</li>

                @if ($user->themes)
                   <li> Используемый скин: {{ $user->themes }}</li>
                @endif
                <li>Дата регистрации: {{ dateFixed($user->created_at, 'd.m.Y') }}</li>

                @if ($invite)
                   <li> Зарегистрирован по приглашению: {!! $invite->user->getProfile() !!}</li>
                @endif

                <li>Последний визит: {{ dateFixed($user->updated_at) }}</li>
                </ul>
            </div>

            <div class="p-block2">
               <div class="img-block">
                @if (!empty($user->picture) && file_exists(HOME . '/' . $user->picture))
                    <a class="gallery" href="{{ $user->picture }}">
                        {!! resizeImage($user->picture, ['alt' => $user->login]) !!}</a>
                @else
                    <img src="/assets/img/images/photo.jpg" alt="Фото">
                @endif
                </div>
                
                <div class="rating-user">
                    @if (getUser() && getUser('login') !== $user->login)
                    <a href="/users/{{ $user->login }}/rating?vote=plus"><i class="fa fa-thumbs-up"></i> Плюс</a>
                    <a class="red" href="/users/{{ $user->login }}/rating?vote=minus">Минус <i class="fa fa-thumbs-down"></i></a>
                @endif
                </div>
                @if (!empty($user->info))
                <div class="o-sebe"><b>О себе :</b><p>{!! bbCode($user->info) !!}</p></div>
                @endif
                
                <div class="post-nav-link">
                <b><a href="/forums/active/topics?user={{ $user->login }}">Форум</a></b><a href="/forums/active/posts?user={{ $user->login }}">Сообщ.</a>
                <b><a href="/downs/active/files?user={{ $user->login }}">Загрузки</a></b><a href="/downs/active/comments?user={{ $user->login }}">комм.</a>
                <b><a href="/blogs/active/articles?user={{ $user->login }}">Блоги</a></b><a href="/blogs/active/comments?user={{ $user->login }}">комм.</a>
                <b><a href="/photos/albums/{{ $user->login }}">Галерея</a></b> <a href="/photos/comments/{{ $user->login }}">комм.</a>
                </div>
                
                <div class="rep">
                     <a href="/ratings/{{ $user->login }}">Репутация: <b>{!! formatNum($user->rating) !!}</b> (+{{  $user->posrating }}/-{{  $user->negrating }})</a>
                </div>
                
            </div>
            
        </div>
    

    @if (isAdmin())
    <div class="alert-block">
    <div class="alert alert-success">
        <i class="fa fa-thumbtack"></i> <b>Заметка:</b> (<a href="/users/{{ $user->login }}/note">Изменить</a>)<br>

        @if (! empty($user->note->text))
            {!! bbCode($user->note->text) !!}<br>
            Изменено: {!! $user->note->editUser->getProfile() !!} ({{ dateFixed($user->note->updated_at) }})<br>
        @else
            Записей еще нет!<br>
        @endif

        </div>
</div>
    @endif

    <div class="user-profil-nav">
       <ul>
         <li><a href="/walls/{{ $user->login }}"><span class="icon"><i class="fa fa-sticky-note"></i></span>Стена сообщений ({{ $user->getCountWall() }})</a></li>

        @if ($user->login !== getUser('login'))
            <li class="db">
            <span><i class="fa fa-address-book"></i> Добавить в</span>
            <a href="/contacts?act=add&amp;user={{ $user->login }}&amp;token={{ $_SESSION['token'] }}">контакт</a>
            <a href="/ignores?act=add&amp;user={{ $user->login }}&amp;token={{ $_SESSION['token'] }}">игнор</a>
           </li>
             <li><a href="/messages/send?user={{ $user->login }}"><span class="icon"><i class="fa fa-envelope"></i></span>Отправить сообщение</a></li>

             <li><a href="/transfers?user={{ $user->login }}"><span class="icon"><i class="fa fa-money-bill-alt"></i></span>Перечислить денег</a></li>

            @if (!empty($user->site))
                 <li><a href="{{ $user->site }}"><span class="icon"><i class="fa fa-home"></i></span>Перейти на сайт {{ $user->login }}</a></li>
            @endif

            @if (isAdmin('moder'))
                @if (setting('invite'))
                     <li><a href="/admin/invitations/send?user={{ $user->login }}&amp;token={{ $_SESSION['token'] }}"><span class="icon"><i class="fa fa-ban"></i></span>Отправить инвайт</a></li>
                @endif
             <li><a href="/admin/bans/edit?user={{ $user->login }}"><span class="icon"><i class="fa fa-ban"></i></span>Бан / Разбан</a></li>
             <li><a href="/banhists/view?user={{ $user->login }}"><span class="icon"><i class="fa fa-history"></i></span>История банов</a></li>
            @endif

            @if (isAdmin('admin'))
                 <li><a href="/admin/users/edit?user={{ $user->login }}"><span class="icon"><i class="fa fa-wrench"></i></span>Редактировать</a></li>
            @endif
        @else
           <li><a href="/profile"><span class="icon"><i class="fa fa-user-circle"></i></span>Мой профиль</a></li>
           <li><a href="/accounts"><span class="icon"><i class="fa fa-cog"></i></span>Мои данные</a></li>
           <li><a href="/settings"><span class="icon"> <i class="fa fa-wrench"></i></span>Настройки</a></li>
        </ul>
        @endif

    </div>
@stop
