@extends('layout')

@section('title')
    Список пользователей (Стр. {{ $page->current }})
@stop

@section('content')

    <h1>Список пользователей</h1>

   <div class="users-list-wrapp">
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item active">Список пользователей</li>
        </ol>
    </nav>

    @if ($users->isNotEmpty())
        @foreach($users as $key => $data)

           <div class="post">
            <div class="b">
                <div class="img">
                    {!! $data->getAvatar() !!}
                    {!! $data->getOnline() !!}
                </div>

                @if ($user == $data->login)
                    {{ ($page->offset + $key + 1) }}. <b>{!! $data->getProfile('#ff0000') !!}</b>
                @else
                    {{ ($page->offset + $key + 1) }}. <b>{!! $data->getProfile() !!}</b>
                @endif
                ({{ plural($data->point, setting('scorename')) }})<br>
                {!! $data->getStatus() !!}
            </div>
             <div class="user-list-end">
                Форум: {{ $data->allforum }} | Гостевая: {{ $data->allguest }} | Комментарии: {{ $data->allcomments }}<br>
                Посещений: {{ $data->visits }}<br>
                Деньги: {{ $data->money }}<br>
                Дата регистрации: {{ dateFixed($data->created_at, 'd.m.Y') }}
            </div>
            </div>
           
        @endforeach

        {!! pagination($page) !!}

        <div class="form">
            <form action="/users" method="post">
                <div class="form-inline">
                    <div class="form-group{{ hasError('user') }}">
                        <input type="text" class="form-control" id="user" name="user" maxlength="20" value="{{ getInput('user', $user) }}" placeholder="Логин пользователя" required>
                    </div>

                    <button class="btn btn-primary">Искать</button>
                </div>
                {!! textError('user') !!}
            </form>
        </div>

       <div class="tex-center">
           <span>Всего пользователей: <b>{{ $page->total }}</b></span>
        </div>
    @else
        {!! showError('Пользователей еще нет!') !!}
    @endif

   <div class="post-nav-link">
    <a href="/who"><i class="fa fa-users"></i> Новички</a>
    <a href="/searchusers"><i class="fas fa-search"></i> Поиск пользователей</a>
       </div>
</div>
@stop
