@extends('layout')

@section('title')
    История голосований (Стр. {{ $page->current }})
@stop

@section('content')

    <h1>История голосований</h1>
<div class="votes-wrapp">
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item"><a href="/votes">Голосования</a></li>
            <li class="breadcrumb-item active">История голосований</li>
        </ol>
    </nav>

    @if ($votes->isNotEmpty())
        @foreach ($votes as $vote)
           <div class="votes">
            <ul>
                <li><a href="/votes/history/{{ $vote->id }}"><span class="icon"><i class="fa fa-briefcase"></i></span>{{ $vote->title }}</a></li>
            </ul>
            
                @if ($vote->topic->id)
                     <a class="f" href="/topics/{{ $vote->topic->id }}">Тема: {{ $vote->topic->title }}</a>
                @endif

               <div class="news-bottom">
                <span>Создано: {{ dateFixed($vote->created_at) }}</span>
                <span>Всего голосов: {{ $vote->count }}</span>
                </div>
           
            </div>
        @endforeach

        {!! pagination($page) !!}
    @else
        {!! showError('Голосований в архиве еще нет!') !!}
    @endif
    </div>
@stop
