@extends('layout')

@section('title')
    Голосования (Стр. {{ $page->current }})
@stop

@section('content')

    <h1>Голосования</h1>
<div class="votes-wrapp">
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item active">Голосования</li>
        </ol>
    </nav>

  @if (getUser())
        <div class="btns">
            <a class="btn btn-success" href="/votes/create">Создать голосование</a>
        </div>
    @endif
   
    @if ($votes->isNotEmpty())
        @foreach ($votes as $vote)
           <div class="votes">
            <ul>
                <li><a href="/votes/{{ $vote['id'] }}"><span class="icon"> <i class="fa fa-chart-bar"></i></span>{{ $vote->title }}</a></li>
            </ul>
           
                @if ($vote->topic->id)
                    <a class="f" href="/topics/{{ $vote->topic->id }}"> Тема: {{ $vote->topic->title }}</a>
                @endif

               <div class="news-bottom">
                   <span>Создано: {{ dateFixed($vote->created_at) }}</span>
                   <span>Всего голосов: {{ $vote->count }}</span>
                </div>
            </div>
        @endforeach

        {!! pagination($page) !!}
    @else
        {!! showError('Открытых голосований еще нет!') !!}
    @endif

   <div class="post-nav-link"><a href="/votes/history"><span class="icon"><i class="fa fa-briefcase"></i> </span>Архив голосований</a></div>
    </div>
@stop
