@extends('layout')

@section('title')
    Голосования {{ $vote->title }}
@stop

@section('content')

    <h1>Голосования {{ $vote->title }}</h1>
<div class="votes-wrapp">
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item"><a href="/votes">Голосования</a></li>
            <li class="breadcrumb-item"><a href="/votes/{{ $vote->id }}">{{ $vote->title }}</a></li>
            <li class="breadcrumb-item active">Голосования</li>
        </ol>
    </nav>

 
    <div class="golos-user"><div class="cents"><i class="fa fa-chart-bar"></i> Голосов: {{ $vote->count }}</div></div>

    @if ($voters->isNotEmpty())
        @foreach ($voters as $voter)
           <div class="golos-user">
            {!! $voter->user->getGender() !!} {!! $voter->user->getProfile() !!} ({{ dateFixed($voter->created_at) }})
             </div>
        @endforeach
    @else
        {!! showError('В голосовании никто не участвовал!') !!}
    @endif
    </div>
@stop


