<?php
header("Content-type:text/html; charset=utf-8");
?>
<!DOCTYPE html>
<html lang="ru">

<head>
    <title>@yield('title') - {{ setting('title') }}</title>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <link rel="shortcut icon" href="/favicon.ico" type="image/x-icon">
    <link rel="image_src" href="/assets/img/images/icon.png">
    @yield('styles')

    @stack('styles')
    <link rel="stylesheet" href="/themes/trums/css/wap.css">
    <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">
    <link rel="alternate" href="/news/rss" title="RSS News" type="application/rss+xml">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <meta name="description" content="@yield('description', setting('description'))">
    <meta name="keywords" content="@yield('keywords', setting('keywords'))">
    <meta name="generator" content="Rotor {{ VERSION }}">
</head>

<body>
  
    <div class="wrapper">
      @if (getUser())
       <div class="event">
            <a href="/messages"><i class="fa fa-envelope"></i></a>
            </div>
            <div class="event1">
            <a class="ev" href="/walls/{{ getUser('login') }}"><i class="fa fa-bullhorn"></i></a>
            </div>
             @endif
        <div class="header">
            <div class="logo">
                <a href="/">{{ setting('title') }}</a>
                <!--<a href="/"><img src="{{ setting('logotip') }}" alt="{{ setting('title') }}"></a>-->
                <!--<span class="dest">{{ setting('logos') }}</span>-->
            </div>

            <div class="nav-menu">
                <button class="toggler"><span class="icon"></span></button>
                <ul>
                    @yield('menu')
                </ul>
            </div>
        </div>






        @yield('advertTop')
        @yield('advertUser')
        @yield('note')
        @yield('flash')
        @yield('layout')
        @yield('advertBottom')


     


        <div class="footer">
            <div class="copy"><a href="/">{{ setting('copy') }}</a></div>
            <div class="only"> @yield('online')</div>
            <div class="counter"> @yield('counter')</div>
            <!--class="counter" Для счетчиков сайта-->


        </div>
        <div class="perf">@yield('performance')</div>



    </div>
    

   


    @yield('scripts')

    @stack('scripts')

   <script src="/themes/trums/js/jsm.js"></script>
   
   


</body>

</html>
