@extends('layout')

@section('title')
    Блоги - Список статей {{ $user->login }} (Стр. {{ $page->current }})
@stop

@section('content')

    <h1>Список статей {{ $user->login }}</h1>

   <div class="blog-wrapp">
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item"><a href="/blogs">Блоги</a></li>
            <li class="breadcrumb-item active">Список статей {{ $user->login }}</li>
        </ol>
    </nav>

   <div class="blog-main-articles-block">
    @if ($blogs->isNotEmpty())
        @foreach ($blogs as $data)
           <div class="blog-main-articles">
            <ul>
                <li><a href="/articles/{{ $data->id }}"><i class="material-icons">person</i>{{ $data->title }} ({!! formatNum($data->rating) !!})</a></li> 
            </ul>

            <div class="blog-main-bottom">
               <span>Автор: {!! $data->user->getProfile() !!} <br> ({{ dateFixed($data->created_at) }})</span>
                <span class="comment"><a href="/articles/comments/{{ $data->id }}"><i class="material-icons">insert_comment</i>{{ $data->count_comments }}</a> 
                </span>
                <!--<a href="/articles/end/{{ $data->id }}">&raquo;</a>-->
            </div>
       </div>
        @endforeach
</div>
        {!! pagination($page) !!}

       <div class="tx-center">
        Всего статей: <b>{{ $page->total }}</b>
       </div>
    @else
        {!! showError('Статей еще нет!') !!}
    @endif
</div>
@stop
