@extends('layout')

@section('title')
    Авторы
@stop

@section('content')

    <h1>Авторы</h1>

   <div class="blog-wrapp">
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item"><a href="/blogs">Блоги</a></li>
            <li class="breadcrumb-item active">Авторы</li>
        </ol>
    </nav>

    @if ($blogs->isNotEmpty())
        @foreach ($blogs as $data)
           <div class="authors-nav">
            <ul>
            <li><a href="/blogs/active/articles?user={{ $data->login }}"> <span><i class="material-icons">account_circle</i></span>{{ $data->login }} ({{ $data->cnt }} cтатей / {{ $data->count_comments }} комм.)</a></li>
               </ul>
</div>
        @endforeach

        {!! pagination($page) !!}

       <div class="txs-center">Всего пользователей: <b>{{ $page->total }}</b></div>
        
    @else
        {!! showError('Статей еще нет!') !!}
    @endif
</div>
@stop
