@extends('layout')

@section('title')
    {{ $category->name }} (Стр. {{ $page->current }})
@stop

@section('content')


    <h1>{{ $category->name }} <small>(Статей: {{ $category->count_blogs }})</small></h1>

   <div class="blog-wrapp">
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item"><a href="/blogs">Блоги</a></li>

            @if ($category->parent->id)
                <li class="breadcrumb-item"><a href="/blogs/{{ $category->parent->id }}">{{ $category->parent->name }}</a></li>
            @endif

            <li class="breadcrumb-item active">{{ $category->name }}</li>

            @if (isAdmin())
                <li class="breadcrumb-item"><a href="/admin/blogs/{{ $category->id }}?page={{ $page->current }}">Управление</a></li>
            @endif
        </ol>
    </nav>

       <div class="main-new-link">
       @if (getUser() && ! $category->closed)
        <div class="l-block">
            <a class="bt" href="/blogs/create?cid={{ $category->id }}">Добавить статью</a>
        </div>
    @endif
       </div>
   
    @if ($blogs->isNotEmpty())
        @foreach ($blogs as $data)
           <div class="blog-article">
            <ul>
                <li><a href="/articles/{{ $data->id }}"><span class="icon-article"><i class="material-icons">
insert_drive_file
</i></span>{{ $data->title }} <span class="count-article">{!! formatNum($data->rating) !!}</span></a></li>
            </ul>
       
            <!--<div class="article-bottom">
               <span><i class="material-icons">perm_identity</i> {!! $data->user->getProfile() !!} </span>
               <span><i class="material-icons">remove_red_eye</i> {{ $data->visits }}</span>
               <span><a href="/articles/comments/{{ $data->id }}"><i class="material-icons">comment</i>{{ $data->count_comments }}</a> </span>
                
            </div>-->
            </div>
        @endforeach

        {!! pagination($page) !!}
    @else
        {!! showError('Статей еще нет, будь первым!') !!}
    @endif

   <div class="post-nav-link">
    <a href="/blogs/top">Топ статей</a>
    <a href="/blogs/tags">Облако тегов</a>
    <a href="/blogs/search">Поиск</a>
    <a href="/blogs/authors">Авторы</a>
</div>
</div>
@stop
