@extends('layout')

@section('title')
    Блоги - Новые статьи (Стр. {{ $page->current }})
@stop

@section('content')

    <h1>Новые статьи</h1>

   <div class="blog-wrapp">
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item"><a href="/blogs">Блоги</a></li>
            <li class="breadcrumb-item active">Новые статьи</li>
        </ol>
    </nav>

   <div class="blog-new-articles-block">
    @if ($blogs->isNotEmpty())
        @foreach ($blogs as $data)
           <div class="blog-new-articles">
            <ul>
                <li><a href="/articles/{{ $data->id }}"><i class="material-icons">public</i>{{ $data->title }} ({!! formatNum($data->rating) !!})</a></li> 
            </ul>

            <div class="blog-new-bottom">
                <a class="cats" href="/blogs/{{ $data->category_id }}"><i class="material-icons">keyboard_arrow_right</i>Категория:  {{ $data->category->name }}</a>
                <div class="blog-new-comm">
                    <span>Добавил: {!! $data->user->getProfile() !!} <br> ({{  dateFixed($data->created_at) }})</span>
                    <span><i class="material-icons">remove_red_eye</i> {{ $data->visits }}</span>
                </div>
            </div>
       </div>
        @endforeach
</div>
        {!! pagination($page) !!}
    @else
        {!! showError('Опубликованных статей еще нет!') !!}
    @endif
</div>
@stop
