@extends('layout')

@section('title')
    {{ $find }} - Результаты поиска
@stop

@section('content')

    <h1>Результаты поиска</h1>

   <div class="blog-wrapp">
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item"><a href="/blogs">Блоги</a></li>
            <li class="breadcrumb-item"><a href="/blogs/search">Поиск</a></li>
            <li class="breadcrumb-item active">Результаты поиска</li>
        </ol>
    </nav>

   <div class="search-tegs-block">
   <div class="top">
    <h3>Поиск запроса &quot;{{ $find }}&quot; в заголовке</h3>
       <p>Найдено совпадений: <b>{{ $page->total }}</b></p>
    </div>

    @foreach ($blogs as $data)
        <div class="search-tegs">

        <ul>
            <li><a href="/articles/{{ $data->id }}"> <i class="fa fa-pencil-alt"></i> {{ $data->title }} ({!! formatNum($data->rating) !!})</a></li> 
        </ul>

         <a class="cats" href="/blogs/{{ $data->category_id }}"><i class="material-icons">chevron_right</i> Категория:{{ $data->name }}</a>
        <div class="bottom-search-tegs">
            Просмотров: {{ $data->visits }}<br>
            Автор: {!! $data->user->getProfile() !!}  ({{ dateFixed($data->created_at) }})
        </div>
        </div>
    @endforeach
       </div>
    {!! pagination($page) !!}
    </div>
@stop
