@extends('layout')

@section('title')
    Топ статей (Стр. {{ $page->current }})
@stop

@section('content')

    <h1>Топ статей</h1>
 <div class="blog-wrapp">
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item"><a href="/blogs">Блоги</a></li>
            <li class="breadcrumb-item active">Топ статей</li>
        </ol>
    </nav>

   <div class="main-new-link">
   <div class="l-block">
    <button class="m">Сортировать: <i class="fa fa-caret-down" aria-hidden="true"></i></button>
    <ul class="main-link">
    <?php $active = ($order === 'visits') ? 'success' : 'light'; ?>
    <li><a href="/blogs/top?sort=visits">Просмотры</a></li>

    <?php $active = ($order === 'rating') ? 'success' : 'light'; ?>
    <li><a href="/blogs/top?sort=rated">Оценки</a></li>

    <?php $active = ($order === 'count_comments') ? 'success' : 'light'; ?>
        <li><a href="/blogs/top?sort=comments">Комментарии</a></li>
    </ul>
    </div>
     </div>

   <div class="top-articles">
    @if ($blogs->isNotEmpty())
        @foreach ($blogs as $data)
          <div class="top-art">
            <ul>
                <li><a href="/articles/{{ $data->id }}"><span><i class="material-icons">favorite</i></span>{{ $data->title }} ({!! formatNum($data->rating) !!})</a></li> 
            </ul>

            <div class="b-bottom">
                <a class="cats" href="/blogs/{{ $data->category_id }}"><i class="material-icons">
keyboard_arrow_right
</i>Категория: {{ $data->name }}</a>
                
                <div class="author-bottom">
                <span>Автор: {!! $data->user->getProfile() !!}</span>
                <span>Просмотров: {{ $data->visits }}</span>
                </div>
                
                <div class="end-comment">
                <a href="/articles/comments/{{ $data->id }}"><i class="material-icons">comment</i> {{ $data->count_comments }}</a>
                </div>
            </div>
            </div>
        @endforeach
        </div>

        {!! pagination($page) !!}
    @else
        {!! showError('Опубликованных статей еще нет!') !!}
    @endif
</div>
@stop
