@extends('layout')

@section('title')
    Мои объявления
@stop

@section('content')

    <h1>Мои объявления <small>(Объявлений: {{ $page->total }})</small></h1>

   <div class="board-wrapp">
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item"><a href="/boards">Объявления</a></li>
            <li class="breadcrumb-item active">Мои объявления</li>
        </ol>
    </nav>

      <div class="board-block">
    @if ($items->isNotEmpty())
        @foreach ($items as $item)
                               <div class="board-content">
                               
                               <div class="board-title">
                                   <h5><a href="/items/{{ $item->id }}"><i class="material-icons">assignment</i>{{ $item->title }}</a></h5>
                               </div>
                               
                                
                                
                                <div class="board-text-block">
                                    <div class="board-img">
                                         <a href="/items/{{ $item->id }}">{!! $item->getFirstImage() !!}</a>
                                         
                                         <div class="price">
                                    @if ($item->price)
                                        <button type="button" class="btn btn-info">{{ $item->price }} ₽</button>
                                    @endif
                                </div>
                                    </div>
                                    
                                    <div class="board-text">
                                        {!! $item->cutText() !!}
                                    </div>
                                </div>
                                
                                
                                    <div class="board-bottom-block">
                                       <span class="author">
                                           <i class="fa fa-user-circle"></i> {!! $item->user->getProfile() !!} / {{ dateFixed($item->created_at) }}

                                        
                                       </span>
                                        <span class="cats">
                                            <a href="/boards/{{ $item->category->id }}"><i class="fas fa-angle-right"></i>{{ $item->category->name }}</a>
                                        </span>
                                    </div>
                                <div class="active-board">
                                    @if ($item->expires_at > SITETIME)
                                            <i class="fas fa-clock"></i> Истекает через {{ formatTime($item->expires_at - SITETIME) }}
                                        @else
                                            <span class="badge badge-danger">Объявление не активно</span>
                                        @endif
                                </div>

                               
                            </div>
                        
        @endforeach
       </div>
        {!! pagination($page) !!}

    @else
        {!! showError('Объявлений еще нет!') !!}
    @endif
</div>
@stop
