@extends('layout')

@section('title')
    Объявления
@stop

@section('content')


    @if ($board)
        <h1>{{ $board->name }} <small>(Объявлений: {{ $board->count_items }})</small></h1>
    @else
        <h1>Объявления</h1>
    @endif

   <div class="board-wrapp">
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>

            @if ($board)
                <li class="breadcrumb-item"><a href="/boards">Объявления</a></li>

                @if ($board->parent->id)
                    <li class="breadcrumb-item"><a href="/boards/{{ $board->parent->id }}">{{ $board->parent->name }}</a></li>
                @endif
                <li class="breadcrumb-item active">{{ $board->name }}</li>

                @if (isAdmin())
                    <li class="breadcrumb-item"><a href="/admin/boards/{{ $board->id  }}?page={{ $page->current }}">Управление</a></li>
                @endif
            @else
                <li class="breadcrumb-item active">Объявления</li>

                @if (isAdmin())
                    <li class="breadcrumb-item"><a href="/admin/boards?page={{ $page->current }}">Управление</a></li>
                @endif
            @endif
        </ol>
    </nav>

  <div class="board-top-link">

    @if (getUser())
             <a href="/boards/active"><i class="material-icons">account_box</i> Мои объявления</a>
    @endif
    
     @if (getUser())
            <a href="/items/create?bid={{ $board->id or 0 }}"><i class="material-icons">note_add</i>Добавить</a>
    @endif
</div>
    @if ($boards->isNotEmpty())
        <div class="board-cat-block">
            @foreach ($boards->chunk(3) as $chunk)
                @foreach ($chunk as $board)
                    
                        <a href="/boards/{{ $board->id }}"><span class="icons-board"><i class="material-icons">folder_special</i></span>{{ $board->name }} <span class="counts-board">{{ $board->count_items }}</span></a>
                    
                @endforeach
            @endforeach
        </div>
    @endif


   <div class="board-block">
    @if ($items->isNotEmpty())
        @foreach ($items as $item)
            <div class="board-content">
                              
                              <div class="board-title">
                                  <h5><a href="/items/{{ $item->id }}"><i class="material-icons">assignment</i> {{ $item->title }}</a></h5>
                              </div>
                               
                               
                               
                                <div class="board-text-block">
                                <div class="board-img">
                                    <a href="/items/{{ $item->id }}">{!! $item->getFirstImage() !!}</a>
                                    
                                     <div class="price">
                                    @if ($item->price)
                                        <button type="button">{{ $item->price }} ₽</button>
                                    @endif
                                </div>
                                </div>
                                   
                                    <div class="board-text">{!! $item->cutText() !!}</div>
                                    
                                </div>

                               
                                <div class="board-bottom-block">
                                <span class="author">
                                <i class="fa fa-user-circle"></i> {!! $item->user->getProfile() !!} / {{ dateFixed($item->created_at) }}</span>
                                
                               <span class="cats"><a href="/boards/{{ $item->category->id }}"><i class="fas fa-angle-right"></i>  {{ $item->category->name }}</a></span>
                               </div>
                               
                          </div>
                       
        @endforeach
</div>
        {!! pagination($page) !!}
    @else
        {!! showError('Объявлений еще нет!') !!}
    @endif
</div>
@stop
