@extends('layout')

@section('title')
    Форум - Список сообщений {{ $user->login }} (Стр. {{ $page->current }})
@stop

@section('content')

    <h1>Список сообщений {{ $user->login }}</h1>
<div class="forum-wrapp">
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item"><a href="/forums">Форум</a></li>
            <li class="breadcrumb-item active">Список сообщений {{ $user->login }}</li>
        </ol>
    </nav>

   <div class="forum-block">
    @foreach ($posts as $data)
        <div class="new-themes-post">
            <ul>
                 <li><a href="/topics/{{ $data->topic_id }}/{{ $data->id }}"><span class="icon-post-new">
                 <i class="material-icons">account_circle</i></span>{{ $data->topic->title }}</a></li>

                <!--@if (isAdmin())
                    <a href="#" class="float-right" onclick="return deletePost(this)" data-tid="{{ $data->id }}" data-token="{{ $_SESSION['token'] }}" data-toggle="tooltip" title="Удалить"><i class="fa fa-times"></i></a>
                @endif-->
            </ul>
            
               <div class="forum-text">
                {!! bbCode($data->text) !!}
                </div>

               <div class="forum-bottom">
               <span> Написал: {{ $data->user->login }} <br>
                ({{ dateFixed($data->created_at) }})</span>
               
                <br>

                @if (isAdmin())
                    <span>({{ $data->brow }}, {{ $data->ip }})</span>
                @endif
            </div>
        </div>
    @endforeach
</div>
    {!! pagination($page) !!}
    </div>
@stop
