@extends('layout')

@section('title')
    {{ $forum->title }} (Стр. {{ $page->current }})
@stop

@section('content')

  

    <h1>{{ $forum->title }}</h1>
<div class="forum-wrapp">
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item"><a href="/forums">Форум</a></li>

            @if ($forum->parent->id)
                <li class="breadcrumb-item"><a href="/forums/{{ $forum->parent->id }}">{{ $forum->parent->title }}</a></li>
            @endif

            <li class="breadcrumb-item active">{{ $forum->title }}</li>

            @if (isAdmin())
                <li class="breadcrumb-item"><a href="/admin/forums/{{  $forum->id  }}?page={{ $page->current }}">Управление</a></li>
            @endif
        </ol>
    </nav>

   <div class="main-new-link">
   <div class="l-block">
    @if (getUser() && ! $forum->closed)
        
            <a class="bt" href="/forums/create?fid={{ $forum->id }}">Создать тему</a>
    @endif
    </div>
    </div>
    
    
    @if ($forum->children->isNotEmpty() && $page->current == 1)
        <div class="podcat-block">

        @foreach ($forum->children as $child)

            <ul>
             <li>
            <a href="/forums/{{ $child->id }}"><i class="material-icons">folder</i>{{ $child->title }} <span class="count">{{ $child->count_topics }}/{{ $child->count_posts }}</span></a> 
             </li>
            </ul>

            @if ($child->lastTopic->id)
                <div class="end-post">
                     <a href="/topics/end/{{ $child->lastTopic->id }}">Тема: {{ $child->lastTopic->title }}
                       @if ($child->lastTopic->lastPost->id) <br>
                        Сообщение: {!! $child->lastTopic->lastPost->user->getProfile(null, false) !!}  ({{ dateFixed($child->lastTopic->lastPost->created_at) }})
                    @endif
                     </a>
                  
                </div>
            @else
                <div class="tx-cent">Темы еще не созданы!</div>
            @endif
        @endforeach

        </div>
    
    @endif

   <div class="forum-block">
    @if ($topics->isNotEmpty())
        @foreach ($topics as $topic)
           <div class="forum-topic">
            <ul id="topic_{{ $topic->id }}">
                <li><a href="/topics/{{ $topic->id }}"><span class="icon"><i class="material-icons">insert_comment</i></span> {{ $topic->title }} <span class="count">{{ $topic->count_posts }}</span> <span class="dats"><i class="material-icons">access_time</i>({{ dateFixed($topic->lastPost->created_at) }})</span> <span class="authors"><i class="material-icons">perm_identity</i>Сообщение: {!! $topic->lastPost->user->getProfile(null, false) !!}</span></a></li> 
    </ul>
            <!--<div class="forum-paginate">
                @if ($topic->lastPost)
                <span>{!! $topic->pagination() !!}</span>
                    <span>Сообщение: {!! $topic->lastPost->user->getProfile(null, false) !!} ({{ dateFixed($topic->lastPost->created_at) }})</span>
                @endif
            </div>-->
            </div>
        @endforeach
</div>
        {!! pagination($page) !!}

    @elseif ($forum->closed)
        {!! showError('В данном разделе запрещено создавать темы!') !!}
    @else
        {!! showError('Тем еще нет, будь первым!') !!}
    @endif

   <div class="post-nav-link">
    <a href="/rules">Правила</a>
    <a href="/forums/top/topics">Топ тем</a>
    <a href="/forums/top/posts">Топ постов</a>
    <a href="/forums/search?fid={{ $forum->id }}">Поиск</a>
    </div>
    </div>
@stop
