@extends('layout')

@section('title')
    Форум
@stop

@section('content')


    <h1>Форум {{ setting('title') }}</h1>
<div class="forum-wrapp">
    @include('advert/_forum')

    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item active">Форум</li>
        </ol>
    </nav>

   <div class="main-new-link">
   <div class="l-block">
    @if (getUser())
       <button class="m">Мои: <i class="fa fa-caret-down" aria-hidden="true"></i></button>
       <ul class="main-link">
           <li><a href="/forums/active/topics">темы</a></li>
           <li><a href="/forums/active/posts">сообщения</a></li>
           <li><a href="/forums/bookmarks">закладки</a></li>
        </ul>
    @endif
</div>
  <div class="l-block">
   <button class="o">Новые: <i class="fa fa-caret-down" aria-hidden="true"></i></button>
   <ul class="ob-link">
    <li><a href="/topics">темы</a></li>
    <li><a href="/posts">сообщения</a></li>
</ul>
</div>
   
   <div class="l-block">
       @if (getUser())
            <a class="bt" href="/forums/create">Создать тему</a>
    @endif
   </div>
    </div>
 
   <div class="forum-block">
    @if ($forums->isNotEmpty())
        @foreach ($forums as $forum)
           <div class="forum">
            <ul>
                
                <li><a href="/forums/{{ $forum->id }}"><span class="icon-forum"><i class="material-icons">folder</i></span>
                {{ $forum->title }} <span class="count">{{ $forum->count_topics }}/{{ $forum->count_posts }}</span></a></li>
                

                @if ($forum->description)
                    <p><small>{{ $forum->description }}</small></p>
                @endif
                
    </ul>

            <div class="podcat">
                @if ($forum->children->isNotEmpty())
                    @foreach ($forum->children as $child)
                <a href="/forums/{{ $child->id }}"><span class="icn"><i class="material-icons">folder_open</i></span>{{ $child->title }} <span class="count">{{ $child->count_topics }}/{{ $child->count_posts }}</span></a>
                    @endforeach
                @endif

               <div class="recent-post">
                @if ($forum->lastTopic->lastPost->id)
                    <a href="/topics/end/{{ $forum->lastTopic->id }}">Тема: {{ $forum->lastTopic->title }} <br>
                      Сообщение: {!! $forum->lastTopic->lastPost->user->getProfile(null, false) !!} ({{ dateFixed($forum->lastTopic->lastPost->created_at) }})
                    </a>
                    
                    @else
                    <div class="tx-cent">
                    Темы еще не созданы!
                     </div>
                @endif
                  
                </div>
                </div>
            <!--<div class="podcat">
                @if ($forum->children->isNotEmpty())
                    @foreach ($forum->children as $child)
                      <i class="material-icons">
folder_open
</i><b><a href="/forums/{{ $child->id }}">{{ $child->title }}</a></b>
                        ({{ $child->count_topics }}/{{ $child->count_posts }})<br/>
                    @endforeach
                @endif

                @if ($forum->lastTopic->lastPost->id)
                    Тема: <a href="/topics/end/{{ $forum->lastTopic->id }}">{{ $forum->lastTopic->title }}</a>
                    <br/>
                    Сообщение: {!! $forum->lastTopic->lastPost->user->getProfile(null, false) !!} ({{ dateFixed($forum->lastTopic->lastPost->created_at) }})
                @else
                    Темы еще не созданы!
                @endif
                </div>-->
            </div>
        @endforeach
        </div>
    @else
        {!! showError('Разделы форума еще не созданы!') !!}
    @endif

    <div class="post-nav-link">
       <a href="/rules">Правила</a>
       <a href="/forums/top/topics">Топ тем</a>
       <a href="/forums/top/posts">Топ постов</a>
       <a href="/forums/search">Поиск</a>
       <a href="/forums/rss">RSS</a>
    </div>
    
    </div>
@stop
