@extends('layout')

@section('title')
    Форум - Новые темы (Стр. {{ $page->current }})
@stop

@section('content')
    <h1>Новые темы</h1>
<div class="forum-wrapp">
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item"><a href="/forums">Форум</a></li>
            <li class="breadcrumb-item active">Новые темы</li>
        </ol>
    </nav>

   <div class="forum-block">
    @foreach ($topics as $data)
       <div class="new-themes-post">
        <ul>
            <li><a href="/topics/{{ $data->id }}"><span class="icon-post-new">
            <i class="material-icons">public</i></span>{{ $data->title }} {{ $data->count_posts }}</a></li> 
        </ul>

        <div class="forum-pagist">
           <div class="p">{!! $data->pagination() !!}</div>
            <a class="f" href="/forums/{{  $data->forum->id }}"><i class="material-icons">keyboard_arrow_right</i>Форум:  {{  $data->forum->title }}</a>
            
            
           </div>
            
            <div class="forum-bottom">
            <span>Автор: {!! $data->user->getProfile(null, false) !!} / Посл.: {!! $data->lastPost->user->getProfile(null, false) !!} ({{ dateFixed($data->created_at) }})
            </span>
            </div>
       
</div>
    @endforeach
    </div>

    {!! pagination($page) !!}
    </div>
@stop
